/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.XML;
import com.oheers.fish.libs.jooq.XMLAttributes;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartCollectionView;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.XMLAttributesImpl;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

final class XMLElement
extends AbstractField<XML>
implements QOM.XMLElement {
    private final Name elementName;
    private final XMLAttributes attributes;
    private final QueryPartList<Field<?>> content;

    XMLElement(Name elementName, XMLAttributes attributes, Collection<? extends Field<?>> content) {
        super(Names.N_XMLELEMENT, SQLDataType.XML);
        this.elementName = elementName;
        this.attributes = attributes == null ? XMLAttributesImpl.EMPTY : attributes;
        this.content = new QueryPartList((Iterable<Field<?>>)content);
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean hasContent = !this.content.isEmpty();
        boolean hasAttributes = !((XMLAttributesImpl)this.attributes).attributes.isEmpty();
        boolean format = hasAttributes || !this.content.isSimple(ctx);
        Consumer<Context> accept0 = c2 -> {
            c2.visit(Keywords.K_NAME).sql(' ').visit(this.elementName);
            if (hasAttributes) {
                if (format) {
                    c2.sql(',').formatSeparator().visit(this.attributes);
                } else {
                    c2.sql(", ").visit(this.attributes);
                }
            }
            if (hasContent) {
                if (format) {
                    c2.sql(',').formatSeparator().visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                } else {
                    c2.sql(", ").visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                }
            }
        };
        ctx.visit(Names.N_XMLELEMENT).sql('(');
        if (format) {
            ctx.formatIndentStart().formatNewLine().data(Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c2 -> accept0.accept((Context)c2)).formatIndentEnd().formatNewLine();
        } else {
            accept0.accept(ctx);
        }
        ctx.sql(')');
    }

    static final Function<? super Field<?>, ? extends Field<?>> xmlCastMapper(Context<?> ctx) {
        return field -> XMLElement.xmlCast(ctx, field);
    }

    static final Field<?> xmlCast(Context<?> ctx, Field<?> field) {
        Field<?> result = field;
        DataType type = field.getDataType();
        switch (ctx.family()) {
            default: 
        }
        if (result != field && Tools.aliased(field) != null) {
            return result.as((Field)field);
        }
        return result;
    }

    @Override
    public final Name $elementName() {
        return this.elementName;
    }

    @Override
    public final XMLAttributes $attributes() {
        return this.attributes;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $content() {
        return QOM.unmodifiable(this.content);
    }
}

