/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.util.jaxb.tools;

import com.oheers.fish.libs.jooq.exception.ConfigurationException;
import com.oheers.fish.libs.jooq.tools.Convert;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.reflect.Reflect;
import com.oheers.fish.libs.jooq.tools.reflect.ReflectException;
import com.oheers.fish.libs.jooq.util.jaxb.tools.XMLAppendable;
import com.oheers.fish.libs.jooq.util.jaxb.tools.XMLBuilder;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jetbrains.annotations.ApiStatus;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ApiStatus.Internal
public final class MiniJAXB {
    private static final JooqLogger log = JooqLogger.getLogger(MiniJAXB.class);
    private static final Map<String, String> PROVIDED_SCHEMAS = new HashMap<String, String>();

    public static String marshal(XMLAppendable object) {
        StringWriter writer = new StringWriter();
        MiniJAXB.marshal(object, writer);
        return writer.toString();
    }

    public static void marshal(XMLAppendable object, OutputStream out) {
        MiniJAXB.marshal(object, new OutputStreamWriter(out));
    }

    public static void marshal(XMLAppendable object, Writer out) {
        try {
            XMLBuilder builder = XMLBuilder.formatting();
            XmlRootElement e = MiniJAXB.getAnnotation(object.getClass(), XmlRootElement.class);
            if (e != null) {
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
                builder.append(e.name(), object);
            } else {
                builder.append(object);
            }
            builder.appendTo(out);
            out.flush();
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot print object", e);
        }
    }

    public static <T extends XMLAppendable> T unmarshal(Reader reader, Class<T> type) {
        return MiniJAXB.unmarshal0(new InputSource(reader), type);
    }

    public static <T extends XMLAppendable> T unmarshal(InputStream in, Class<T> type) {
        return MiniJAXB.unmarshal0(new InputSource(in), type);
    }

    public static <T extends XMLAppendable> T unmarshal(String xml, Class<T> type) {
        return MiniJAXB.unmarshal0(new InputSource(new StringReader(xml)), type);
    }

    public static <T extends XMLAppendable> T unmarshal(File xml, Class<T> type) {
        try {
            return MiniJAXB.unmarshal0(new InputSource(new FileInputStream(xml)), type);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while opening file", e);
        }
    }

    private static <T extends XMLAppendable> T unmarshal0(InputSource in, Class<T> type) {
        try {
            MiniJAXB.addDefaultNamespace(in, type);
            Document document = MiniJAXB.builder(type).parse(in);
            XMLAppendable result = (XMLAppendable)Reflect.on(type).create().get();
            MiniJAXB.unmarshal0(result, document.getDocumentElement(), new IdentityHashMap());
            return (T)result;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while reading xml", e);
        }
    }

    private static void addDefaultNamespace(InputSource in, Class<?> type) throws IOException {
        String namespace = MiniJAXB.getNamespace(type);
        if (namespace != null) {
            Reader reader = in.getCharacterStream() != null ? in.getCharacterStream() : new InputStreamReader(in.getByteStream(), in.getEncoding() != null ? in.getEncoding() : Charset.defaultCharset().name());
            StringWriter writer = new StringWriter();
            MiniJAXB.copyLarge(reader, writer);
            String xml = writer.toString();
            int startIdx = xml.indexOf(60);
            while (startIdx > 0 && xml.length() > startIdx + 1 && xml.charAt(startIdx + 1) == '?') {
                startIdx = xml.indexOf(60, startIdx + 1);
            }
            int endIdx = xml.indexOf(62, startIdx);
            if (!xml.substring(startIdx, endIdx).contains("xmlns")) {
                xml = xml.replaceFirst("<([a-z_]+)\\s*(/?>)", "<$1 xmlns=\"" + namespace + "\"$2");
            }
            in.setCharacterStream(new StringReader(xml));
        }
    }

    private static long copyLarge(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            writer.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static void unmarshal0(Object result, Element element, Map<Class<?>, Map<String, Field>> fieldsByClass) throws Exception {
        if (result == null) {
            return;
        }
        Map<String, Field> fieldsByElementName = MiniJAXB.fieldsByElementName(fieldsByClass, result.getClass());
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            MiniJAXB.unmarshal1(result, item, fieldsByClass, fieldsByElementName);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            MiniJAXB.unmarshal1(result, item, fieldsByClass, fieldsByElementName);
        }
    }

    private static void unmarshal1(Object result, Node item, Map<Class<?>, Map<String, Field>> fieldsByClass, Map<String, Field> fieldsByName) throws Exception {
        Field child = null;
        Element childElement = null;
        String textContent = null;
        if (item.getNodeType() == 1) {
            childElement = (Element)item;
            child = fieldsByName.remove(childElement.getTagName());
            if (child == null) {
                child = fieldsByName.remove(childElement.getLocalName());
            }
            if (child != null) {
                textContent = childElement.getTextContent();
            }
        } else if (item.getNodeType() == 2) {
            Attr childAttr = (Attr)item;
            child = fieldsByName.remove(childAttr.getName());
            if (child == null) {
                child = fieldsByName.remove(childAttr.getLocalName());
            }
            if (child != null) {
                textContent = childAttr.getValue();
            }
        }
        if (child == null) {
            return;
        }
        XmlElementWrapper w = child.getAnnotation(XmlElementWrapper.class);
        XmlElement e = child.getAnnotation(XmlElement.class);
        XmlJavaTypeAdapter a2 = child.getAnnotation(XmlJavaTypeAdapter.class);
        XmlList l = child.getAnnotation(XmlList.class);
        String childName = child.getName();
        Class<?> childType = child.getType();
        if (List.class.isAssignableFrom(childType) && w != null && e != null) {
            if (childElement == null) {
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            MiniJAXB.unmarshalList0(list, childElement, e.name(), (Class)((ParameterizedType)child.getGenericType()).getActualTypeArguments()[0], fieldsByClass);
            Reflect.on(result).set(childName, list);
        } else if (List.class.isAssignableFrom(childType) && l != null) {
            if (childElement == null) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(childElement.getTextContent().split(" +")));
            Reflect.on(result).set(childName, Convert.convert(list, (Class)((ParameterizedType)child.getGenericType()).getActualTypeArguments()[0]));
        } else if (MiniJAXB.getAnnotation(childType, XmlEnum.class) != null) {
            Reflect.on(result).set(childName, Reflect.onClass(childType).call("fromValue", textContent.trim()));
        } else if (MiniJAXB.getAnnotation(childType, XmlType.class) != null) {
            Object object = Reflect.on(childType).create().get();
            Reflect.on(result).set(childName, object);
            MiniJAXB.unmarshal0(object, childElement, fieldsByClass);
        } else if (a2 != null) {
            XmlAdapter adapter = a2.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Reflect.on(result).set(childName, adapter.unmarshal(textContent.trim()));
        } else {
            Reflect.on(result).set(childName, Convert.convert((Object)textContent.trim(), childType));
        }
    }

    private static void unmarshalList0(List<Object> result, Element element, String name, Class<?> type, Map<Class<?>, Map<String, Field>> fieldsByClass) throws Exception {
        if (result == null) {
            return;
        }
        boolean isComplexType = MiniJAXB.getAnnotation(type, XmlType.class) != null;
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1 || !name.equals(((Element)item).getTagName()) && !name.equals(((Element)item).getLocalName())) continue;
            if (isComplexType) {
                Object o = Reflect.on(type).create().get();
                MiniJAXB.unmarshal0(o, (Element)item, fieldsByClass);
                result.add(o);
                continue;
            }
            result.add(Convert.convert((Object)item.getTextContent().trim(), type));
        }
    }

    private static Map<String, Field> fieldsByElementName(Map<Class<?>, Map<String, Field>> fieldsByClass, Class<?> type) {
        Map<String, Field> result = fieldsByClass.get(type);
        if (result == null) {
            result = new HashMap<String, Field>();
            fieldsByClass.put(type, result);
            for (Field child : type.getDeclaredFields()) {
                int modifiers = child.getModifiers();
                if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
                XmlElementWrapper w = child.getAnnotation(XmlElementWrapper.class);
                XmlElement e = child.getAnnotation(XmlElement.class);
                String childName = child.getName();
                String childElementName = w != null ? ("##default".equals(w.name()) ? child.getName() : w.name()) : (e == null || "##default".equals(e.name()) ? childName : e.name());
                result.put(childElementName, child);
            }
        }
        return new HashMap<String, Field>(result);
    }

    private static DocumentBuilder builder(Class<?> type) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setXIncludeAware(false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            String namespace = MiniJAXB.getNamespace(type);
            if (namespace != null) {
                try {
                    Schema schema = MiniJAXB.getSchema(type, namespace);
                    factory.setSchema(schema);
                }
                catch (UnsupportedOperationException schema) {
                    // empty catch block
                }
            }
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    log.warn(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    log.warn(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    log.warn(exception);
                }
            });
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getNamespace(Class<?> type) {
        if (type != null && type.getPackage() != null && type.getPackage().isAnnotationPresent(XmlSchema.class)) {
            return type.getPackage().getAnnotation(XmlSchema.class).namespace();
        }
        return null;
    }

    private static Schema getSchema(Class<?> type, String namespace) {
        try {
            URL url = PROVIDED_SCHEMAS.containsKey(namespace) ? type.getResource(PROVIDED_SCHEMAS.get(namespace)) : new URL(namespace);
            if (url != null) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(url);
                return schema;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load schema for namespace " + namespace), e);
        }
        return null;
    }

    public static <T> T append(T first, T second) {
        Class<?> secondClass;
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        Class<?> firstClass = first.getClass();
        if (!firstClass.isAssignableFrom(secondClass = second.getClass()) && !secondClass.isAssignableFrom(firstClass)) {
            throw new IllegalArgumentException("Can only append compatible types");
        }
        if (firstClass.isEnum()) {
            return first;
        }
        Package pkg = firstClass.getPackage();
        try {
            Class<?> defaultsClass = MiniJAXB.nonGradleExtensionClass(firstClass);
            Object defaults = defaultsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Method setter : firstClass.getMethods()) {
                Object defaultChild;
                Method secondGetter;
                Method firstGetter;
                Method defaultsGetter;
                if (!setter.getName().startsWith("set") || setter.getParameterCount() != 1) continue;
                try {
                    defaultsClass.getMethod(setter.getName(), setter.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                try {
                    defaultsGetter = defaultsClass.getMethod("get" + setter.getName().substring(3), new Class[0]);
                    firstGetter = firstClass.getMethod("get" + setter.getName().substring(3), new Class[0]);
                    secondGetter = secondClass.getMethod("get" + setter.getName().substring(3), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    defaultsGetter = defaultsClass.getMethod("is" + setter.getName().substring(3), new Class[0]);
                    firstGetter = firstClass.getMethod("is" + setter.getName().substring(3), new Class[0]);
                    secondGetter = firstClass.getMethod("is" + setter.getName().substring(3), new Class[0]);
                }
                Class<?> childType = setter.getParameterTypes()[0];
                Object firstChild = firstGetter.invoke(first, new Object[0]);
                Object secondChild = secondGetter.invoke(second, new Object[0]);
                Object object = defaultChild = defaults != null ? defaultsGetter.invoke(defaults, new Object[0]) : null;
                if (Collection.class.isAssignableFrom(childType)) {
                    ((List)firstChild).addAll((List)secondChild);
                    continue;
                }
                if (secondChild != null && (firstChild == null || firstChild.equals(defaultChild))) {
                    setter.invoke(first, secondChild);
                    continue;
                }
                if (secondChild == null || pkg != childType.getPackage()) continue;
                MiniJAXB.append(firstChild, secondChild);
            }
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
        return first;
    }

    private static <T> Class<T> nonGradleExtensionClass(Class<T> klass) {
        while (klass.getName().startsWith("com.oheers.fish.libs.jooq.codegen.gradle")) {
            klass = klass.getSuperclass();
        }
        return klass;
    }

    private static <A extends Annotation> A getAnnotation(Class<?> klass, Class<A> annotation) {
        return MiniJAXB.nonGradleExtensionClass(klass).getAnnotation(annotation);
    }

    static {
        PROVIDED_SCHEMAS.put("http://www.jooq.org/xsd/jooq-codegen-3.19.8.xsd", "/com/oheers/fish/libs/jooq/meta/xsd/jooq-codegen-3.19.8.xsd");
        PROVIDED_SCHEMAS.put("http://www.jooq.org/xsd/jooq-export-3.10.0.xsd", "/com/oheers/fish/libs/jooq/xsd/jooq-export-3.10.0.xsd");
        PROVIDED_SCHEMAS.put("http://www.jooq.org/xsd/jooq-meta-3.19.0.xsd", "/com/oheers/fish/libs/jooq/xsd/jooq-meta-3.19.0.xsd");
        PROVIDED_SCHEMAS.put("http://www.jooq.org/xsd/jooq-runtime-3.19.27.xsd", "/com/oheers/fish/libs/jooq/xsd/jooq-runtime-3.19.27.xsd");
    }
}

