/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.util.jaxb.tools;

import com.oheers.fish.libs.jooq.tools.StringUtils;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringAdapter
extends XmlAdapter<String, String> {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    @Override
    public final String unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        String result = v.trim();
        Matcher matcher = PROPERTY_PATTERN.matcher(result);
        while (matcher.find()) {
            String group0 = matcher.group(0);
            String group1 = matcher.group(1);
            result = StringUtils.replace(result, group0, System.getProperty(group1, group0));
        }
        return result;
    }

    @Override
    public final String marshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        return v.trim();
    }
}

