/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bukkit;

import com.rappytv.labyutils.bukkit.LabyUtilsBukkit;
import com.rappytv.labyutils.common.IConfigManager;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;

public class BukkitConfigManager
implements IConfigManager<ConfigurationSection> {
    private final LabyUtilsBukkit plugin;
    private Configuration config;

    public BukkitConfigManager(LabyUtilsBukkit plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    @Override
    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    @Override
    public String getPrefix() {
        return this.config.getString("prefix", "\u00a78[\u00a79LABY\u00a78] ");
    }

    @Override
    public boolean isLabyModDisallowed() {
        return this.config.getBoolean("disallow.enabled");
    }

    @Override
    public String getDisallowedKickMessage() {
        return this.config.getString("disallow.kickMessage", "\u00a7c\u00a7lKICKED!\n\n\u00a7bReason: \u00a77You are not allowed to join this server using \u00a79LabyMod\u00a77!");
    }

    @Override
    public boolean isWelcomeLogEnabled() {
        return this.config.getBoolean("welcome.log");
    }

    @Override
    public boolean isWelcomeMessageEnabled() {
        return this.config.getBoolean("welcome.enabled");
    }

    @Override
    public String getWelcomeMessage() {
        return this.config.getString("welcome.message");
    }

    @Override
    public boolean isBannerEnabled() {
        return this.config.getBoolean("banner.enabled");
    }

    @Override
    public String getBannerUrl() {
        return this.config.getString("banner.url", "");
    }

    @Override
    public int getEconomyUpdateInterval() {
        return this.config.getInt("economy.updateInterval");
    }

    @Override
    public boolean showCashBalance() {
        return this.config.getBoolean("economy.cash");
    }

    @Override
    public boolean showBankBalance() {
        return this.config.getBoolean("economy.bank");
    }

    @Override
    public boolean areFlagsEnabled() {
        return this.config.getBoolean("flags.enabled");
    }

    @Override
    public boolean areSubtitlesEnabled() {
        return this.config.getBoolean("subtitles.enabled");
    }

    @Override
    public ConfigurationSection getSubtitles() {
        return this.config.getConfigurationSection("subtitles.subtitles");
    }

    @Override
    public boolean areInteractionsEnabled() {
        return this.config.getBoolean("interactions.enabled");
    }

    @Override
    public ConfigurationSection getInteractionBullets() {
        return this.config.getConfigurationSection("interactions.bullets");
    }

    @Override
    public boolean isAddonManagementEnabled() {
        return this.config.getBoolean("addons.enabled");
    }

    @Override
    public ConfigurationSection getAddonManagement() {
        return this.config.getConfigurationSection("addons.addons");
    }

    @Override
    public String getAddonKickMessage() {
        return this.config.getString("addons.kickMessage", "\u00a7c\u00a7lKICKED!\n\n\u00a7bReason: \u00a77Missing required addons: %s");
    }

    @Override
    public boolean arePermissionsEnabled() {
        return this.config.getBoolean("permissions.enabled");
    }

    @Override
    public ConfigurationSection getPermissions() {
        return this.config.getConfigurationSection("permissions.permissions");
    }

    @Override
    public boolean isRpcEnabled() {
        return this.config.getBoolean("rpc.enabled");
    }

    @Override
    public String getRpcText() {
        return this.config.getString("rpc.text");
    }

    @Override
    public boolean showRpcJoinTime() {
        return this.config.getBoolean("rpc.showJoinTime");
    }
}

