/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bukkit;

import com.rappytv.labyutils.bukkit.BukkitConfigManager;
import com.rappytv.labyutils.bukkit.commands.LabyInfoCommand;
import com.rappytv.labyutils.bukkit.commands.ReloadCommand;
import com.rappytv.labyutils.bukkit.events.EconomyBalanceUpdateEvent;
import com.rappytv.labyutils.bukkit.expansion.LabyModPlayerExpansion;
import com.rappytv.labyutils.bukkit.listeners.EconomyBalanceUpdateListener;
import com.rappytv.labyutils.bukkit.listeners.PlayerListener;
import com.rappytv.labyutils.common.ILabyUtilsPlugin;
import java.util.Objects;
import net.labymod.serverapi.server.bukkit.LabyModProtocolService;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class LabyUtilsBukkit
extends JavaPlugin
implements ILabyUtilsPlugin {
    private static LabyUtilsBukkit instance;
    private Economy economy = null;
    private boolean usingPapi = false;
    private BukkitConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new BukkitConfigManager(this);
        try {
            LabyModProtocolService.initialize(this);
            this.getLogger().info("LabyMod protocol service initialized.");
        }
        catch (IllegalStateException e) {
            this.getLogger().info("LabyMod protocol service already initialized.");
        }
        if (this.loadVaultEconomy()) {
            this.getLogger().info("Vault is installed, loaded economy provider!");
        } else {
            this.getLogger().warning("Vault not accessible. Economy display disabled.");
        }
        if (this.loadPlaceholderAPI()) {
            this.getLogger().info("PlaceholderAPI is installed. Registering expansion...");
            new LabyModPlayerExpansion(this).register();
        } else {
            this.getLogger().warning("PlaceholderAPI not installed.");
        }
        EconomyBalanceUpdateEvent.initialize(this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new EconomyBalanceUpdateListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"labyinfo")).setExecutor((CommandExecutor)new LabyInfoCommand(this));
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"labyutils")).setExecutor((CommandExecutor)new ReloadCommand(this));
    }

    public static String getPrefix() {
        return instance.getConfigManager().getPrefix();
    }

    @Nullable
    public Economy getEconomy() {
        return this.economy;
    }

    public boolean isUsingPapi() {
        return this.usingPapi;
    }

    public BukkitConfigManager getConfigManager() {
        return this.configManager;
    }

    private boolean loadVaultEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            return false;
        }
        this.economy = (Economy)provider.getProvider();
        return true;
    }

    private boolean loadPlaceholderAPI() {
        this.usingPapi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        return this.usingPapi;
    }
}

