/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bukkit.commands;

import com.rappytv.labyutils.bukkit.LabyUtilsBukkit;
import com.rappytv.labyutils.common.ILabyUtilsPlugin;
import java.util.Collections;
import java.util.List;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.LabyModProtocolService;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LabyInfoCommand
implements CommandExecutor,
TabExecutor {
    private final LabyUtilsBukkit plugin;

    public LabyInfoCommand(LabyUtilsBukkit plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String prefix, @NotNull String[] args) {
        if (!sender.hasPermission("labyutils.info")) {
            sender.sendMessage(LabyUtilsBukkit.getPrefix() + "\u00a7cYou are not allowed to use this command!");
            return false;
        }
        if (args.length < 1) {
            sender.sendMessage(LabyUtilsBukkit.getPrefix() + "\u00a7cPlease enter a player name!");
            return false;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        if (player == null) {
            sender.sendMessage(LabyUtilsBukkit.getPrefix() + "\u00a7cThis player was not found!");
            return false;
        }
        String response = LabyUtilsBukkit.getPrefix() + "\u00a76LabyInfo of " + player.getName();
        LabyModPlayer labyPlayer = (LabyModPlayer)LabyModProtocolService.get().getPlayer(player.getUniqueId());
        response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bUUID: \u00a77" + String.valueOf(player.getUniqueId());
        if (labyPlayer == null) {
            response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bUsing LabyMod: \u00a7cNo";
            sender.sendMessage(response);
            return true;
        }
        response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bUsing LabyMod: \u00a7aYes";
        if (this.plugin.getConfigManager().areSubtitlesEnabled() && sender.hasPermission("labyutils.info.subtitle")) {
            ServerAPITextComponent component = (ServerAPITextComponent)labyPlayer.subtitle().getText();
            String subtitle = component != null ? component.getText() : "--";
            response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bServer subtitle: \u00a77" + subtitle;
        }
        if (sender.hasPermission("labyutils.info.economy")) {
            response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bEconomy cash: \u00a77" + this.plugin.formatNumber(labyPlayer.cashEconomy().getBalance()) + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bEconomy bank: \u00a77" + this.plugin.formatNumber(labyPlayer.bankEconomy().getBalance());
        }
        if (sender.hasPermission("labyutils.info.version")) {
            response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bLabyMod version: \u00a77v" + labyPlayer.getLabyModVersion();
        }
        if (sender.hasPermission("labyutils.info.region")) {
            String flag = ILabyUtilsPlugin.cachedFlags.containsKey(player.getUniqueId()) ? ILabyUtilsPlugin.cachedFlags.get(player.getUniqueId()).name() : "--";
            response = response + "\n" + LabyUtilsBukkit.getPrefix() + "\u00a7bRegion: \u00a77" + flag;
        }
        sender.sendMessage(response);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return Collections.emptyList();
    }
}

