/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bukkit.expansion;

import com.rappytv.labyutils.bukkit.LabyUtilsBukkit;
import com.rappytv.labyutils.common.ILabyUtilsPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.LabyModProtocolService;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabyModPlayerExpansion
extends PlaceholderExpansion {
    private final LabyUtilsBukkit plugin;

    public LabyModPlayerExpansion(LabyUtilsBukkit plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "labyutils";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            switch (identifier.toLowerCase()) {
                case "banner": {
                    if (!this.plugin.getConfigManager().isBannerEnabled()) {
                        return "";
                    }
                    return this.plugin.getConfigManager().getBannerUrl();
                }
            }
            return null;
        }
        LabyModPlayer labyPlayer = (LabyModPlayer)LabyModProtocolService.get().getPlayer(player.getUniqueId());
        if (labyPlayer == null) {
            return "";
        }
        switch (identifier.toLowerCase()) {
            case "playerflag": {
                return ILabyUtilsPlugin.cachedFlags.containsKey(player.getUniqueId()) ? ILabyUtilsPlugin.cachedFlags.get(player.getUniqueId()).name() : "--";
            }
            case "subtitle": {
                ServerAPITextComponent component = (ServerAPITextComponent)labyPlayer.subtitle().getText();
                return component != null ? component.getText() : "";
            }
            case "clientversion": {
                return labyPlayer.getLabyModVersion();
            }
            case "cash": {
                return String.valueOf(labyPlayer.cashEconomy().getBalance());
            }
            case "bank": {
                return String.valueOf(labyPlayer.bankEconomy().getBalance());
            }
        }
        return null;
    }
}

