/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bukkit.listeners;

import com.rappytv.labyutils.bukkit.LabyUtilsBukkit;
import com.rappytv.labyutils.bukkit.events.EconomyBalanceUpdateEvent;
import com.rappytv.labyutils.common.listeners.IPlayerListener;
import java.util.ArrayList;
import me.clip.placeholderapi.PlaceholderAPI;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.core.model.display.TabListFlag;
import net.labymod.serverapi.core.model.feature.DiscordRPC;
import net.labymod.serverapi.core.model.feature.InteractionMenuEntry;
import net.labymod.serverapi.core.model.moderation.Permission;
import net.labymod.serverapi.core.model.moderation.RecommendedAddon;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.event.LabyModPlayerJoinEvent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener,
IPlayerListener<LabyModPlayerJoinEvent, LabyModPlayer> {
    private final LabyUtilsBukkit plugin;

    public PlayerListener(LabyUtilsBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerJoin(LabyModPlayerJoinEvent event) {
        LabyModPlayer labyPlayer = event.labyModPlayer();
        if (this.disallowLabyMod(labyPlayer)) {
            return;
        }
        this.logJoin(labyPlayer);
        this.sendWelcomer(labyPlayer);
        this.setBanner(labyPlayer);
        this.setFlag(labyPlayer);
        this.setSubtitle(labyPlayer);
        this.setInteractionBullets(labyPlayer);
        this.manageAddons(labyPlayer);
        this.managePermissions(labyPlayer);
        this.setRPC(labyPlayer);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        EconomyBalanceUpdateEvent.cashBalances.remove(event.getPlayer().getUniqueId());
        EconomyBalanceUpdateEvent.bankBalances.remove(event.getPlayer().getUniqueId());
    }

    @Override
    public boolean disallowLabyMod(LabyModPlayer player) {
        if (this.plugin.getConfigManager().isLabyModDisallowed() && !((Player)player.getPlayer()).hasPermission("labyutils.bypass.labymod")) {
            ((Player)player.getPlayer()).kickPlayer(this.plugin.getConfigManager().getDisallowedKickMessage());
            return true;
        }
        return false;
    }

    @Override
    public void logJoin(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isWelcomeLogEnabled()) {
            return;
        }
        this.plugin.getLogger().info(String.format("%s just joined with LabyMod v%s!", ((Player)player.getPlayer()).getName(), player.getLabyModVersion()));
    }

    @Override
    public void sendWelcomer(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isWelcomeMessageEnabled()) {
            return;
        }
        String text = this.plugin.getConfigManager().getWelcomeMessage().replace("<prefix>", this.plugin.getConfigManager().getPrefix());
        if (this.plugin.isUsingPapi()) {
            text = PlaceholderAPI.setPlaceholders((Player)((Player)player.getPlayer()), (String)text);
        }
        ((Player)player.getPlayer()).sendMessage(text);
    }

    @Override
    public void setBanner(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isBannerEnabled()) {
            return;
        }
        player.sendTabListBanner(this.plugin.getConfigManager().getBannerUrl());
    }

    @Override
    public void setFlag(LabyModPlayer player) {
        this.plugin.getCountryCode(player.getUniqueId(), ((Player)player.getPlayer()).getAddress(), flag -> {
            if (flag != null && this.plugin.getConfigManager().areFlagsEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.setTabListFlag((TabListFlag.TabListFlagCountryCode)((Object)flag)));
            }
        });
    }

    @Override
    public void setSubtitle(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().areSubtitlesEnabled()) {
            return;
        }
        ConfigurationSection section = this.plugin.getConfigManager().getSubtitles();
        if (section == null) {
            return;
        }
        ServerAPITextComponent component = null;
        double size = -1.0;
        for (String key : section.getKeys(false)) {
            String permission = section.getString(key + ".permission");
            String text = section.getString(key + ".text");
            if (permission == null || text == null || !((Player)player.getPlayer()).hasPermission(permission)) continue;
            if (this.plugin.isUsingPapi()) {
                text = PlaceholderAPI.setPlaceholders((Player)((Player)player.getPlayer()), (String)text);
            }
            component = ServerAPIComponent.text(text);
            size = section.getDouble(key + ".size");
            break;
        }
        if (component == null || size <= 0.0) {
            player.resetSubtitle();
            return;
        }
        player.updateSubtitle(component, size);
    }

    @Override
    public void setInteractionBullets(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().areInteractionsEnabled()) {
            return;
        }
        ArrayList<InteractionMenuEntry> entries = new ArrayList<InteractionMenuEntry>();
        ConfigurationSection section = this.plugin.getConfigManager().getInteractionBullets();
        for (String key : section.getKeys(false)) {
            if (section.isString(key + ".permission") && !((Player)player.getPlayer()).hasPermission(section.getString(key + ".permission"))) continue;
            try {
                entries.add(InteractionMenuEntry.create(ServerAPIComponent.text(section.getString(key + ".title")), InteractionMenuEntry.InteractionMenuType.valueOf(section.getString(key + ".type").toUpperCase().replace(' ', '_')), section.getString(key + ".value")));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to build interaction bullet with id " + key);
            }
        }
        if (!entries.isEmpty()) {
            player.sendInteractionMenuEntries(entries);
        }
    }

    @Override
    public void managePermissions(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().arePermissionsEnabled()) {
            return;
        }
        ArrayList<Permission.StatedPermission> permissions = new ArrayList<Permission.StatedPermission>();
        ConfigurationSection section = this.plugin.getConfigManager().getPermissions();
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            boolean hasPermission = ((Player)player.getPlayer()).hasPermission("labyutils.permissions.*") || ((Player)player.getPlayer()).hasPermission("labyutils.permissions." + section.getString(key));
            permissions.add(hasPermission ? Permission.of(key).allow() : Permission.of(key).deny());
        }
        player.sendPermissions(permissions);
    }

    @Override
    public void setRPC(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isRpcEnabled()) {
            return;
        }
        String text = this.plugin.getConfigManager().getRpcText();
        boolean showTime = this.plugin.getConfigManager().showRpcJoinTime();
        if (text == null) {
            return;
        }
        if (this.plugin.isUsingPapi()) {
            text = PlaceholderAPI.setPlaceholders((Player)((Player)player.getPlayer()), (String)text);
        }
        DiscordRPC rpc = showTime ? DiscordRPC.createWithStart(text, System.currentTimeMillis()) : DiscordRPC.create(text);
        player.sendDiscordRPC(rpc);
    }

    @Override
    public void manageAddons(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isAddonManagementEnabled()) {
            return;
        }
        ArrayList<RecommendedAddon> recommendedAddons = new ArrayList<RecommendedAddon>();
        ArrayList<String> disabledAddons = new ArrayList<String>();
        ConfigurationSection section = this.plugin.getConfigManager().getAddonManagement();
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            boolean canBypass;
            boolean bl = canBypass = ((Player)player.getPlayer()).hasPermission("labyutils.bypass.addon.*") || ((Player)player.getPlayer()).hasPermission("labyutils.bypass.addon." + key);
            if (canBypass) continue;
            switch (section.getString(key, "none").toLowerCase()) {
                case "recommend": {
                    recommendedAddons.add(RecommendedAddon.of(key, false));
                    break;
                }
                case "require": {
                    recommendedAddons.add(RecommendedAddon.of(key, true));
                    break;
                }
                case "disable": {
                    disabledAddons.add(key);
                }
            }
        }
        if (!recommendedAddons.isEmpty()) {
            player.sendAddonRecommendations(recommendedAddons, response -> {
                if (response.isInitial()) {
                    return;
                }
                ArrayList<String> missingRequiredAddons = new ArrayList<String>();
                for (String missingAddon : response.getMissingAddons()) {
                    for (RecommendedAddon addon : recommendedAddons) {
                        if (!addon.getNamespace().equals(missingAddon) || !addon.isRequired()) continue;
                        missingRequiredAddons.add(missingAddon);
                    }
                }
                if (!missingRequiredAddons.isEmpty() && ((Player)player.getPlayer()).isOnline()) {
                    ((Player)player.getPlayer()).kickPlayer(String.format(this.plugin.getConfigManager().getAddonKickMessage(), String.join((CharSequence)", ", missingRequiredAddons)));
                }
            });
        }
        if (!disabledAddons.isEmpty()) {
            player.disableAddons(disabledAddons);
        }
    }
}

