/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bungee;

import com.rappytv.labyutils.bungee.LabyUtilsConfig;
import com.rappytv.labyutils.common.IConfigManager;
import net.md_5.bungee.config.Configuration;

public class BungeeConfigManager
implements IConfigManager<Configuration> {
    private final LabyUtilsConfig pluginConfig;
    private Configuration config;

    public BungeeConfigManager(LabyUtilsConfig config) {
        this.pluginConfig = config;
        this.config = this.pluginConfig.get();
    }

    @Override
    public void reloadConfig() {
        this.pluginConfig.reload();
        this.config = this.pluginConfig.get();
    }

    @Override
    public String getPrefix() {
        return this.config.getString("prefix", "\u00a78[\u00a79LABY\u00a78] ");
    }

    @Override
    public boolean isLabyModDisallowed() {
        return this.config.getBoolean("disallow.enabled");
    }

    @Override
    public String getDisallowedKickMessage() {
        return this.config.getString("disallow.kickMessage", "\u00a7c\u00a7lKICKED!\n\n\u00a7bReason: \u00a77You are not allowed to join this server using \u00a79LabyMod\u00a77!");
    }

    @Override
    public boolean isWelcomeLogEnabled() {
        return this.config.getBoolean("welcome.log");
    }

    @Override
    public boolean isWelcomeMessageEnabled() {
        return this.config.getBoolean("welcome.enabled");
    }

    @Override
    public String getWelcomeMessage() {
        return this.config.getString("welcome.message");
    }

    @Override
    public boolean isBannerEnabled() {
        return this.config.getBoolean("banner.enabled");
    }

    @Override
    public String getBannerUrl() {
        return this.config.getString("banner.url", "");
    }

    @Override
    public int getEconomyUpdateInterval() {
        return -1;
    }

    @Override
    public boolean showCashBalance() {
        return false;
    }

    @Override
    public boolean showBankBalance() {
        return false;
    }

    @Override
    public boolean areFlagsEnabled() {
        return this.config.getBoolean("flags.enabled");
    }

    @Override
    public boolean areSubtitlesEnabled() {
        return this.config.getBoolean("subtitles.enabled");
    }

    @Override
    public Configuration getSubtitles() {
        return this.config.getSection("subtitles.subtitles");
    }

    @Override
    public boolean areInteractionsEnabled() {
        return this.config.getBoolean("interactions.enabled");
    }

    @Override
    public Configuration getInteractionBullets() {
        return this.config.getSection("interactions.bullets");
    }

    @Override
    public boolean isAddonManagementEnabled() {
        return this.config.getBoolean("addons.enabled");
    }

    @Override
    public Configuration getAddonManagement() {
        return this.config.getSection("addons.addons");
    }

    @Override
    public String getAddonKickMessage() {
        return this.config.getString("addons.kickMessage", "\u00a7c\u00a7lKICKED!\n\n\u00a7bReason: \u00a77Missing required addons: %s");
    }

    @Override
    public boolean arePermissionsEnabled() {
        return this.config.getBoolean("permissions.enabled");
    }

    @Override
    public Configuration getPermissions() {
        return this.config.getSection("permissions.permissions");
    }

    @Override
    public boolean isRpcEnabled() {
        return this.config.getBoolean("rpc.enabled");
    }

    @Override
    public String getRpcText() {
        return this.config.getString("rpc.text");
    }

    @Override
    public boolean showRpcJoinTime() {
        return this.config.getBoolean("rpc.showJoinTime");
    }
}

