/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bungee;

import com.rappytv.labyutils.bungee.LabyUtilsBungee;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class LabyUtilsConfig {
    private static final ConfigurationProvider provider = ConfigurationProvider.getProvider(YamlConfiguration.class);
    private final LabyUtilsBungee plugin;
    private final File configFolder;
    private final File configFile;
    private Configuration configuration;

    public LabyUtilsConfig(LabyUtilsBungee plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        this.configFile = new File(this.configFolder, "config.yml");
        this.reload();
    }

    public void reload() {
        try {
            if (!this.configFolder.exists()) {
                this.configFolder.mkdir();
            }
            if (!this.configFile.exists()) {
                FileOutputStream outputStream = new FileOutputStream(this.configFile);
                InputStream in = this.plugin.getResourceAsStream("config_bungee.yml");
                in.transferTo(outputStream);
                in.close();
            }
            this.configuration = provider.load(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load plugin configuration!");
        }
    }

    public Configuration get() {
        if (this.configuration == null) {
            throw new IllegalStateException("Configuration is not yet initialized!");
        }
        return this.configuration;
    }
}

