/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bungee.commands;

import com.rappytv.labyutils.bungee.LabyUtilsBungee;
import com.rappytv.labyutils.common.ILabyUtilsPlugin;
import java.util.ArrayList;
import java.util.Collections;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.server.bungeecord.LabyModPlayer;
import net.labymod.serverapi.server.bungeecord.LabyModProtocolService;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class LabyInfoCommand
extends Command
implements TabExecutor {
    private final LabyUtilsBungee plugin;

    public LabyInfoCommand(LabyUtilsBungee plugin) {
        super("labyinfo", "labyutils.info", new String[0]);
        this.plugin = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("labyutils.info")) {
            sender.sendMessage(TextComponent.fromLegacyText((String)(LabyUtilsBungee.getPrefix() + "\u00a7cYou are not allowed to use this command!")));
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(TextComponent.fromLegacyText((String)(LabyUtilsBungee.getPrefix() + "\u00a7cPlease enter a player name!")));
            return;
        }
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(TextComponent.fromLegacyText((String)(LabyUtilsBungee.getPrefix() + "\u00a7cThis player was not found!")));
            return;
        }
        String response = LabyUtilsBungee.getPrefix() + "\u00a76LabyInfo of " + player.getName();
        LabyModPlayer labyPlayer = (LabyModPlayer)LabyModProtocolService.get().getPlayer(player.getUniqueId());
        response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bUUID: \u00a77" + String.valueOf(player.getUniqueId());
        if (labyPlayer == null) {
            response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bUsing LabyMod: \u00a7cNo";
            sender.sendMessage(TextComponent.fromLegacyText((String)response));
            return;
        }
        response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bUsing LabyMod: \u00a7aYes";
        if (this.plugin.getConfigManager().areSubtitlesEnabled() && sender.hasPermission("labyutils.info.subtitle")) {
            ServerAPITextComponent component = (ServerAPITextComponent)labyPlayer.subtitle().getText();
            String subtitle = component != null ? component.getText() : "--";
            response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bServer subtitle: \u00a77" + subtitle;
        }
        if (sender.hasPermission("labyutils.info.economy")) {
            response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bEconomy cash: \u00a77" + this.plugin.formatNumber(labyPlayer.cashEconomy().getBalance()) + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bEconomy bank: \u00a77" + this.plugin.formatNumber(labyPlayer.bankEconomy().getBalance());
        }
        if (sender.hasPermission("labyutils.info.version")) {
            response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bLabyMod version: \u00a77v" + labyPlayer.getLabyModVersion();
        }
        if (sender.hasPermission("labyutils.info.region")) {
            String flag = ILabyUtilsPlugin.cachedFlags.containsKey(player.getUniqueId()) ? ILabyUtilsPlugin.cachedFlags.get(player.getUniqueId()).name() : "--";
            response = response + "\n" + LabyUtilsBungee.getPrefix() + "\u00a7bRegion: \u00a77" + flag;
        }
        sender.sendMessage(TextComponent.fromLegacyText((String)response));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (ProxiedPlayer player : this.plugin.getProxy().getPlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                players.add(player.getName());
            }
            return players;
        }
        return Collections.emptyList();
    }
}

