/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.bungee.listener;

import com.rappytv.labyutils.bungee.LabyUtilsBungee;
import com.rappytv.labyutils.common.listeners.IPlayerListener;
import java.util.ArrayList;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.core.model.display.TabListFlag;
import net.labymod.serverapi.core.model.feature.DiscordRPC;
import net.labymod.serverapi.core.model.feature.InteractionMenuEntry;
import net.labymod.serverapi.core.model.moderation.Permission;
import net.labymod.serverapi.core.model.moderation.RecommendedAddon;
import net.labymod.serverapi.server.bungeecord.LabyModPlayer;
import net.labymod.serverapi.server.bungeecord.event.LabyModPlayerJoinEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.event.EventHandler;

public class PlayerListener
implements Listener,
IPlayerListener<LabyModPlayerJoinEvent, LabyModPlayer> {
    private final LabyUtilsBungee plugin;

    public PlayerListener(LabyUtilsBungee plugin) {
        this.plugin = plugin;
    }

    @Override
    @EventHandler
    public void onPlayerJoin(LabyModPlayerJoinEvent event) {
        LabyModPlayer labyPlayer = event.labyModPlayer();
        if (this.disallowLabyMod(labyPlayer)) {
            return;
        }
        this.logJoin(labyPlayer);
        this.sendWelcomer(labyPlayer);
        this.setBanner(labyPlayer);
        this.setFlag(labyPlayer);
        this.setSubtitle(labyPlayer);
        this.setInteractionBullets(labyPlayer);
        this.managePermissions(labyPlayer);
        this.setRPC(labyPlayer);
        this.manageAddons(labyPlayer);
    }

    @Override
    public boolean disallowLabyMod(LabyModPlayer player) {
        if (this.plugin.getConfigManager().isLabyModDisallowed() && !((ProxiedPlayer)player.getPlayer()).hasPermission("labyutils.bypass.labymod")) {
            ((ProxiedPlayer)player.getPlayer()).disconnect(TextComponent.fromLegacyText((String)this.plugin.getConfigManager().getDisallowedKickMessage()));
            return true;
        }
        return false;
    }

    @Override
    public void logJoin(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isWelcomeLogEnabled()) {
            return;
        }
        this.plugin.getLogger().info(String.format("%s just joined with LabyMod v%s!", ((ProxiedPlayer)player.getPlayer()).getName(), player.getLabyModVersion()));
    }

    @Override
    public void sendWelcomer(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isWelcomeMessageEnabled()) {
            return;
        }
        String text = this.plugin.getConfigManager().getWelcomeMessage().replace("<prefix>", this.plugin.getConfigManager().getPrefix());
        ((ProxiedPlayer)player.getPlayer()).sendMessage(TextComponent.fromLegacyText((String)text));
    }

    @Override
    public void setBanner(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isBannerEnabled()) {
            return;
        }
        player.sendTabListBanner(this.plugin.getConfigManager().getBannerUrl());
    }

    @Override
    public void setFlag(LabyModPlayer player) {
        this.plugin.getCountryCode(player.getUniqueId(), ((ProxiedPlayer)player.getPlayer()).getAddress(), flag -> {
            if (flag != null && this.plugin.getConfigManager().areFlagsEnabled()) {
                this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> player.setTabListFlag((TabListFlag.TabListFlagCountryCode)((Object)flag)));
            }
        });
    }

    @Override
    public void setSubtitle(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().areSubtitlesEnabled()) {
            return;
        }
        Configuration section = this.plugin.getConfigManager().getSubtitles();
        if (section == null) {
            return;
        }
        ServerAPITextComponent component = null;
        double size = -1.0;
        for (String key : section.getKeys()) {
            String permission = section.getString(key + ".permission");
            String text = section.getString(key + ".text");
            if (permission == null || text == null || !((ProxiedPlayer)player.getPlayer()).hasPermission(permission)) continue;
            component = ServerAPIComponent.text(text);
            size = section.getDouble(key + ".size");
            break;
        }
        if (component == null || size <= 0.0) {
            player.resetSubtitle();
            return;
        }
        player.updateSubtitle(component, size);
    }

    @Override
    public void setInteractionBullets(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().areInteractionsEnabled()) {
            return;
        }
        ArrayList<InteractionMenuEntry> entries = new ArrayList<InteractionMenuEntry>();
        Configuration section = this.plugin.getConfigManager().getInteractionBullets();
        for (String key : section.getKeys()) {
            if (section.contains(key + ".permission") && !((ProxiedPlayer)player.getPlayer()).hasPermission(section.getString(key + ".permission"))) continue;
            try {
                entries.add(InteractionMenuEntry.create(ServerAPIComponent.text(section.getString(key + ".title")), InteractionMenuEntry.InteractionMenuType.valueOf(section.getString(key + ".type").toUpperCase().replace(' ', '_')), section.getString(key + ".value")));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to build interaction bullet with id " + key);
            }
        }
        if (!entries.isEmpty()) {
            player.sendInteractionMenuEntries(entries);
        }
    }

    @Override
    public void managePermissions(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().arePermissionsEnabled()) {
            return;
        }
        ArrayList<Permission.StatedPermission> permissions = new ArrayList<Permission.StatedPermission>();
        Configuration section = this.plugin.getConfigManager().getPermissions();
        if (section == null) {
            return;
        }
        for (String key : section.getKeys()) {
            boolean hasPermission = ((ProxiedPlayer)player.getPlayer()).hasPermission("labyutils.permissions.*") || ((ProxiedPlayer)player.getPlayer()).hasPermission("labyutils.permissions." + section.getString(key));
            permissions.add(hasPermission ? Permission.of(key).allow() : Permission.of(key).deny());
        }
        player.sendPermissions(permissions);
    }

    @Override
    public void setRPC(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isRpcEnabled()) {
            return;
        }
        String text = this.plugin.getConfigManager().getRpcText();
        boolean showTime = this.plugin.getConfigManager().showRpcJoinTime();
        if (text == null) {
            return;
        }
        DiscordRPC rpc = showTime ? DiscordRPC.createWithStart(text, System.currentTimeMillis()) : DiscordRPC.create(text);
        player.sendDiscordRPC(rpc);
    }

    @Override
    public void manageAddons(LabyModPlayer player) {
        if (!this.plugin.getConfigManager().isAddonManagementEnabled()) {
            return;
        }
        ArrayList<RecommendedAddon> recommendedAddons = new ArrayList<RecommendedAddon>();
        ArrayList<String> disabledAddons = new ArrayList<String>();
        Configuration section = this.plugin.getConfigManager().getAddonManagement();
        if (section == null) {
            return;
        }
        for (String key : section.getKeys()) {
            boolean canBypass;
            boolean bl = canBypass = ((ProxiedPlayer)player.getPlayer()).hasPermission("labyutils.bypass.addon.*") || ((ProxiedPlayer)player.getPlayer()).hasPermission("labyutils.bypass.addon." + key);
            if (canBypass) continue;
            switch (section.getString(key, "none").toLowerCase()) {
                case "recommend": {
                    recommendedAddons.add(RecommendedAddon.of(key, false));
                    break;
                }
                case "require": {
                    recommendedAddons.add(RecommendedAddon.of(key, true));
                    break;
                }
                case "disable": {
                    disabledAddons.add(key);
                }
            }
        }
        if (!recommendedAddons.isEmpty()) {
            player.sendAddonRecommendations(recommendedAddons, response -> {
                if (response.isInitial()) {
                    return;
                }
                ArrayList<String> missingRequiredAddons = new ArrayList<String>();
                for (String missingAddon : response.getMissingAddons()) {
                    for (RecommendedAddon addon : recommendedAddons) {
                        if (!addon.getNamespace().equals(missingAddon) || !addon.isRequired()) continue;
                        missingRequiredAddons.add(missingAddon);
                    }
                }
                if (!missingRequiredAddons.isEmpty() && ((ProxiedPlayer)player.getPlayer()).isConnected()) {
                    ((ProxiedPlayer)player.getPlayer()).disconnect(TextComponent.fromLegacyText((String)String.format(this.plugin.getConfigManager().getAddonKickMessage(), String.join((CharSequence)", ", missingRequiredAddons))));
                }
            });
        }
        if (!disabledAddons.isEmpty()) {
            player.disableAddons(disabledAddons);
        }
    }
}

