/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labyutils.common;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.labymod.serverapi.core.model.display.TabListFlag;
import org.jetbrains.annotations.Nullable;

public interface ILabyUtilsPlugin {
    public static final Map<UUID, TabListFlag.TabListFlagCountryCode> cachedFlags = new HashMap<UUID, TabListFlag.TabListFlagCountryCode>();
    public static final Gson gson = new Gson();
    public static final HttpClient client = HttpClient.newHttpClient();

    public Logger getLogger();

    default public String formatNumber(double number) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        formatter.setMaximumFractionDigits(2);
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(number);
    }

    default public void getCountryCode(UUID uuid, InetSocketAddress address, Consumer< @Nullable TabListFlag.TabListFlagCountryCode> consumer) {
        if (cachedFlags.containsKey(uuid)) {
            consumer.accept(cachedFlags.get(uuid));
            return;
        }
        if (address == null) {
            consumer.accept(null);
            return;
        }
        String host = address.getHostString();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.country.is/" + host)).method("GET", HttpRequest.BodyPublishers.noBody()).build();
            ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                JsonObject body = gson.fromJson((String)response.body(), JsonObject.class);
                cachedFlags.put(uuid, TabListFlag.TabListFlagCountryCode.valueOf(body.get("country").getAsString()));
                consumer.accept(cachedFlags.get(uuid));
            })).exceptionally(throwable -> {
                this.getLogger().warning("Failed to get country code of " + host);
                consumer.accept(null);
                return null;
            });
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to get country code of " + host);
            consumer.accept(null);
        }
    }
}

