/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api;

import java.util.Objects;
import java.util.UUID;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.api.ProtocolRegistry;
import net.labymod.serverapi.api.logger.ProtocolPlatformLogger;
import net.labymod.serverapi.api.packet.Direction;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.PayloadChannelIdentifier;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProtocolService {
    public static final UUID DUMMY_UUID = new UUID(0L, 0L);
    private final ProtocolRegistry registry;
    private final Side side;

    protected AbstractProtocolService(@NotNull Side side) {
        Objects.requireNonNull(side, "Side cannot be null");
        this.side = side;
        this.registry = new ProtocolRegistry();
    }

    @NotNull
    public Side getSide() {
        return this.side;
    }

    @NotNull
    public final ProtocolRegistry registry() {
        return this.registry;
    }

    public abstract void send(@NotNull PayloadChannelIdentifier var1, @NotNull UUID var2, @NotNull PayloadWriter var3);

    @NotNull
    public abstract ProtocolPlatformLogger logger();

    public abstract boolean isInitialized();

    public void afterPacketHandled(@NotNull Protocol protocol, @NotNull Packet packet, @NotNull UUID sender) {
    }

    public void afterPacketSent(@NotNull Protocol protocol, @NotNull Packet packet, @NotNull UUID recipient) {
    }

    public static enum Side {
        CLIENT(Direction.CLIENTBOUND),
        SERVER(Direction.SERVERBOUND);

        private final Direction incomingDirection;

        private Side(Direction direction) {
            this.incomingDirection = direction;
        }

        public boolean isAcceptingDirection(Direction direction) {
            return direction == Direction.BOTH || this.incomingDirection == direction;
        }
    }
}

