/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.labymod.serverapi.api.AbstractProtocolService;
import net.labymod.serverapi.api.packet.Direction;
import net.labymod.serverapi.api.packet.IdentifiablePacket;
import net.labymod.serverapi.api.packet.OnlyWriteConstructor;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.packet.PacketHandler;
import net.labymod.serverapi.api.payload.PayloadChannelIdentifier;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class Protocol {
    protected final PayloadChannelIdentifier identifier;
    private final Set<ProtocolPacket> packets;
    private final AbstractProtocolService protocolService;
    private final AbstractProtocolService.Side protocolSide;
    private final Set<AwaitingResponse> awaitingResponses;

    public Protocol(@NotNull AbstractProtocolService protocolService, @NotNull PayloadChannelIdentifier identifier) {
        Objects.requireNonNull(identifier, "Identifier cannot be null");
        Objects.requireNonNull(protocolService, "Protocol service cannot be null");
        this.identifier = identifier;
        this.protocolService = protocolService;
        this.protocolSide = protocolService.getSide();
        this.packets = new HashSet<ProtocolPacket>();
        this.awaitingResponses = new HashSet<AwaitingResponse>();
        if (this.identifier.toString().length() > 20) {
            this.protocolService.logger().warn("The identifier of the protocol " + this.identifier + " is longer than 20 characters. This will cause issues with 1.8 & 1.12.2 users.", new Object[0]);
        }
    }

    @NotNull
    public final PayloadChannelIdentifier identifier() {
        return this.identifier;
    }

    public <T extends Packet> void registerPacket(int id, @NotNull Class<T> packetClass, @NotNull Direction direction) {
        this.registerPacket(id, packetClass, direction, null);
    }

    public <T extends Packet> void registerPacket(int id, @NotNull Class<T> packetClass, @NotNull Direction direction, @Nullable PacketHandler<T> handler) {
        Objects.requireNonNull(packetClass, "Packet cannot be null");
        Objects.requireNonNull(direction, "Direction cannot be null");
        ProtocolPacket protocolPacket = new ProtocolPacket(id, packetClass, direction);
        if (handler != null) {
            protocolPacket.handlers.add(handler);
        }
        this.packets.add(protocolPacket);
    }

    @Nullable
    public final Class<? extends Packet> getPacket(int id) {
        ProtocolPacket protocolPacket = this.getProtocolPacketById(id);
        return protocolPacket != null ? protocolPacket.packet : null;
    }

    public boolean hasPacket(Class<? extends Packet> packetClass) {
        return this.getProtocolPacketByClass(packetClass) != null;
    }

    public final int getPacketId(Class<? extends Packet> packetClass) {
        ProtocolPacket protocolPacket = this.getProtocolPacketByClass(packetClass);
        return protocolPacket != null ? protocolPacket.id : Integer.MIN_VALUE;
    }

    public final <T extends Packet> void registerHandler(@NotNull Class<T> packetClass, @NotNull PacketHandler<T> handler) {
        Objects.requireNonNull(packetClass, "Packet cannot be null");
        Objects.requireNonNull(handler, "Handler cannot be null");
        ProtocolPacket protocolPacket = this.getProtocolPacketByClass(packetClass);
        if (protocolPacket == null) {
            throw new IllegalArgumentException("No packet with the id " + packetClass.getSimpleName() + " in protocol " + this.identifier + "found");
        }
        for (PacketHandler packetHandler : protocolPacket.handlers) {
            if (packetHandler != handler) continue;
            throw new UnsupportedOperationException("Packet " + packetClass.getSimpleName() + " in protocol " + this.identifier + " already has " + handler.getClass().getSimpleName() + " as handler");
        }
        protocolPacket.handlers.add(handler);
    }

    public void handlePacket(@NotNull UUID sender, @NotNull Packet packet) {
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        ProtocolPacket protocolPacket = this.getProtocolPacketByClass(packet.getClass());
        if (protocolPacket == null) {
            throw new IllegalArgumentException("No packet with the id " + packet.getClass().getSimpleName() + " in protocol " + this.identifier + "found");
        }
        if (!this.protocolSide.isAcceptingDirection(protocolPacket.direction)) {
            return;
        }
        this.handlePacket(protocolPacket, sender, packet);
    }

    @Nullable
    public Packet handleIncomingPayload(@NotNull UUID sender, @NotNull PayloadReader reader) throws Exception {
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(reader, "Reader cannot be null");
        int id = reader.readVarInt();
        ProtocolPacket protocolPacket = this.getProtocolPacketById(id);
        if (protocolPacket == null) {
            return null;
        }
        if (!this.protocolSide.isAcceptingDirection(protocolPacket.direction)) {
            return null;
        }
        Packet packet = protocolPacket.createPacket();
        packet.read(reader);
        this.handlePacket(protocolPacket, sender, packet);
        return packet;
    }

    public <R extends IdentifiablePacket> void sendPacket(@NotNull UUID recipient, @NotNull IdentifiablePacket packet, @NotNull Class<R> responseClass, @NotNull Predicate<R> responseCallback) {
        Objects.requireNonNull(responseClass, "Response class cannot be null");
        Objects.requireNonNull(responseCallback, "Response callback cannot be null");
        this.sendPacketInternal(recipient, packet, responseClass, responseCallback);
    }

    public void sendPacket(@NotNull UUID recipient, @NotNull Packet packet) {
        this.sendPacketInternal(recipient, packet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void clearAwaitingResponsesFor(UUID recipient) {
        Set<AwaitingResponse> set = this.awaitingResponses;
        synchronized (set) {
            this.awaitingResponses.removeIf(response -> ((AwaitingResponse)response).recipient.equals(recipient));
        }
    }

    private ProtocolPacket getProtocolPacket(Predicate<ProtocolPacket> filter) {
        for (ProtocolPacket packet : this.packets) {
            if (!filter.test(packet)) continue;
            return packet;
        }
        return null;
    }

    private ProtocolPacket getProtocolPacketByClass(Class<? extends Packet> packetClass) {
        return this.getProtocolPacket(packet -> ((ProtocolPacket)packet).packet == packetClass);
    }

    private ProtocolPacket getProtocolPacketById(int id) {
        return this.getProtocolPacket(packet -> ((ProtocolPacket)packet).id == id);
    }

    private void handlePacket(ProtocolPacket protocolPacket, UUID sender, Packet packet) {
        if (packet instanceof IdentifiablePacket) {
            IdentifiablePacket identifiablePacket = (IdentifiablePacket)packet;
            AwaitingResponse responsePacket = null;
            for (AwaitingResponse awaitingResponse : this.awaitingResponses) {
                if (!awaitingResponse.recipient.equals(sender) || !awaitingResponse.responseClass.equals(protocolPacket.packet) || identifiablePacket.getIdentifier() != awaitingResponse.identifier) continue;
                responsePacket = awaitingResponse;
                break;
            }
            if (responsePacket != null) {
                try {
                    if (!responsePacket.responseCallback.test(identifiablePacket)) {
                        this.awaitingResponses.remove(responsePacket);
                    }
                }
                catch (Exception e) {
                    this.protocolService.logger().warn("Failed to handle packet response " + packet.getClass().getSimpleName(), e);
                }
            }
        }
        for (PacketHandler handler : protocolPacket.handlers) {
            try {
                handler.handle(sender, packet);
            }
            catch (Exception e) {
                this.protocolService.logger().warn("Failed to handle packet " + packet.getClass().getSimpleName(), e);
            }
        }
        this.protocolService.afterPacketHandled(this, packet, sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacketInternal(@NotNull UUID recipient, @NotNull Packet packet, @Nullable Class<? extends IdentifiablePacket> responseClass, @Nullable Predicate<? extends IdentifiablePacket> responseCallback) {
        Objects.requireNonNull(recipient, "Recipient cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        ProtocolPacket protocolPacket = this.getProtocolPacketByClass(packet.getClass());
        if (protocolPacket == null) {
            throw new IllegalArgumentException("No packet with the class " + packet.getClass().getSimpleName() + " in protocol " + this.identifier + "found");
        }
        if (this.protocolSide.isAcceptingDirection(protocolPacket.direction)) {
            return;
        }
        PayloadWriter writer = new PayloadWriter();
        writer.writeVarInt(protocolPacket.id);
        packet.write(writer);
        this.protocolService.send(this.identifier, recipient, writer);
        if (responseClass != null && responseCallback != null && packet instanceof IdentifiablePacket) {
            IdentifiablePacket identifiablePacket = (IdentifiablePacket)packet;
            Set<AwaitingResponse> set = this.awaitingResponses;
            synchronized (set) {
                this.awaitingResponses.add(new AwaitingResponse(recipient, identifiablePacket, identifiablePacket.getIdentifier(), responseClass, responseCallback));
            }
        }
        this.protocolService.afterPacketSent(this, packet, recipient);
    }

    private static class ProtocolPacket {
        private static final UnsafeProvider UNSAFE_PROVIDER = new UnsafeProvider();
        private final int id;
        private final Class<? extends Packet> packet;
        private final Set<PacketHandler> handlers;
        private final Direction direction;
        private boolean fromConstructor = true;
        private Constructor<? extends Packet> constructor;

        private ProtocolPacket(int id, Class<? extends Packet> packet, Direction direction) {
            this.id = id;
            this.packet = packet;
            this.direction = direction;
            this.handlers = new HashSet<PacketHandler>();
        }

        private Packet createPacket() throws Exception {
            if (this.constructor == null && this.fromConstructor) {
                try {
                    this.constructor = this.packet.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                    this.fromConstructor = !this.constructor.isAnnotationPresent(OnlyWriteConstructor.class);
                }
                catch (Exception e) {
                    this.fromConstructor = false;
                }
            }
            if (this.fromConstructor) {
                return this.constructor.newInstance(new Object[0]);
            }
            return (Packet)UNSAFE_PROVIDER.unsafe.allocateInstance(this.packet);
        }
    }

    private final class AwaitingResponse {
        private final UUID recipient;
        private final IdentifiablePacket initialPacket;
        private final int identifier;
        private final Class responseClass;
        private final Predicate responseCallback;

        private AwaitingResponse(UUID recipient, IdentifiablePacket initialPacket, int identifier, Class responseClass, Predicate responseCallback) {
            this.recipient = recipient;
            this.initialPacket = initialPacket;
            this.identifier = identifier;
            this.responseClass = responseClass;
            this.responseCallback = responseCallback;
        }

        public UUID recipient() {
            return this.recipient;
        }

        public IdentifiablePacket initialPacket() {
            return this.initialPacket;
        }

        public int identifier() {
            return this.identifier;
        }

        public Class responseClass() {
            return this.responseClass;
        }

        public Predicate responseCallback() {
            return this.responseCallback;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            AwaitingResponse that = (AwaitingResponse)obj;
            return Objects.equals(this.recipient, that.recipient) && Objects.equals(this.initialPacket, that.initialPacket) && this.identifier == that.identifier && Objects.equals(this.responseClass, that.responseClass) && Objects.equals(this.responseCallback, that.responseCallback);
        }

        public int hashCode() {
            return Objects.hash(this.recipient, this.initialPacket, this.identifier, this.responseClass, this.responseCallback);
        }

        public String toString() {
            return "AwaitingResponse[recipient=" + this.recipient + ", initialPacket=" + this.initialPacket + ", identifier=" + this.identifier + ", responseClass=" + this.responseClass + ", responseCallback=" + this.responseCallback + ']';
        }
    }

    private static final class UnsafeProvider {
        private final Unsafe unsafe;

        private UnsafeProvider() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                this.unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to get unsafe instance", exception);
            }
        }
    }
}

