/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.labymod.serverapi.api.Protocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ProtocolRegistry {
    private final Set<Protocol> protocols = new HashSet<Protocol>();
    private final Set<Protocol> unmodifiableProtocols = Collections.unmodifiableSet(this.protocols);
    private final Set<Consumer<Protocol>> registerListeners = new HashSet<Consumer<Protocol>>();

    protected ProtocolRegistry() {
    }

    public void registerProtocol(@NotNull Protocol protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be null");
        this.protocols.add(protocol);
        for (Consumer<Protocol> registerListener : this.registerListeners) {
            registerListener.accept(protocol);
        }
    }

    public void unregisterProtocol(@NotNull Protocol protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be null");
        this.protocols.remove(protocol);
    }

    public void addRegisterListener(@NotNull Consumer<Protocol> listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        this.registerListeners.add(listener);
        for (Protocol protocol : this.protocols) {
            listener.accept(protocol);
        }
    }

    public @Unmodifiable Set<Protocol> getProtocols() {
        return this.unmodifiableProtocols;
    }
}

