/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.model.component;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextColor;
import net.labymod.serverapi.api.model.component.ServerAPITextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerAPIBaseComponent<T extends ServerAPIBaseComponent<?>>
implements ServerAPIComponent {
    private ServerAPITextColor textColor;
    private EnumMap<ServerAPITextDecoration, Boolean> decorations = new EnumMap(ServerAPITextDecoration.class);
    private List<ServerAPIComponent> children = new ArrayList<ServerAPIComponent>();

    @NotNull
    public T append(@NotNull ServerAPIComponent component) {
        this.children.add(component);
        return (T)this;
    }

    @NotNull
    public T append(int index, @NotNull ServerAPIComponent component) {
        this.children.add(index, component);
        return (T)this;
    }

    @NotNull
    public T remove(int index) {
        this.children.remove(index);
        return (T)this;
    }

    @NotNull
    public T replace(int index, @NotNull ServerAPIComponent component) {
        this.children.set(index, component);
        return (T)this;
    }

    @NotNull
    public T color(ServerAPITextColor color) {
        this.textColor = color;
        return (T)this;
    }

    @NotNull
    public T colorIfAbsent(ServerAPITextColor color) {
        if (this.textColor == null) {
            this.textColor = color;
        }
        return (T)this;
    }

    @NotNull
    public T decorate(ServerAPITextDecoration decoration) {
        this.decorations.put(decoration, true);
        return (T)this;
    }

    @NotNull
    public T decorate(ServerAPITextDecoration ... decorations) {
        for (ServerAPITextDecoration decoration : decorations) {
            this.decorations.put(decoration, true);
        }
        return (T)this;
    }

    @NotNull
    public T undecorate(ServerAPITextDecoration decoration) {
        this.decorations.put(decoration, false);
        return (T)this;
    }

    @NotNull
    public T undecorate(ServerAPITextDecoration ... decorations) {
        for (ServerAPITextDecoration decoration : decorations) {
            this.decorations.put(decoration, false);
        }
        return (T)this;
    }

    @NotNull
    public T unsetDecoration(ServerAPITextDecoration decoration) {
        this.decorations.remove((Object)decoration);
        return (T)this;
    }

    @NotNull
    public T unsetDecoration(ServerAPITextDecoration ... decorations) {
        for (ServerAPITextDecoration decoration : decorations) {
            this.decorations.remove((Object)decoration);
        }
        return (T)this;
    }

    @NotNull
    public T applyStyleFrom(@NotNull ServerAPIComponent component) {
        if (component instanceof ServerAPIBaseComponent) {
            this.textColor = ((ServerAPIBaseComponent)component).textColor;
            this.decorations = new EnumMap<ServerAPITextDecoration, Boolean>(((ServerAPIBaseComponent)component).decorations);
        }
        return (T)this;
    }

    @Override
    public boolean hasDecoration(ServerAPITextDecoration decoration) {
        return this.decorations.get((Object)decoration) == Boolean.TRUE;
    }

    @Override
    public boolean isDecorationSet(ServerAPITextDecoration decoration) {
        return this.decorations.get((Object)decoration) != null;
    }

    @Override
    public EnumMap<ServerAPITextDecoration, Boolean> getDecorations() {
        return this.decorations;
    }

    @Override
    public List<ServerAPIComponent> getChildren() {
        return this.children;
    }

    @NotNull
    public T setChildren(@NotNull List<ServerAPIComponent> children) {
        this.children = children;
        return (T)this;
    }

    @Override
    @Nullable
    public ServerAPITextColor getColor() {
        return this.textColor;
    }

    public String toString() {
        return "ServerAPIBaseComponent{textColor=" + this.textColor + ", decorations=" + this.decorations + ", children=" + this.children + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerAPIBaseComponent)) {
            return false;
        }
        ServerAPIBaseComponent that = (ServerAPIBaseComponent)o;
        return Objects.equals(this.textColor, that.textColor) && Objects.equals(this.decorations, that.decorations) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.textColor, this.decorations, this.children);
    }
}

