/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.model.component;

import java.util.EnumMap;
import java.util.List;
import net.labymod.serverapi.api.model.component.ServerAPITextColor;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ServerAPIComponent {
    @NotNull
    public static ServerAPITextComponent text(@NotNull String text) {
        return new ServerAPITextComponent(text);
    }

    @NotNull
    public static ServerAPITextComponent text(@NotNull String text, @Nullable ServerAPITextColor color) {
        return (ServerAPITextComponent)ServerAPIComponent.text(text).color(color);
    }

    @NotNull
    public static ServerAPITextComponent text(@NotNull String text, @Nullable ServerAPITextColor color, ServerAPITextDecoration ... decorations) {
        return (ServerAPITextComponent)ServerAPIComponent.text(text, color).decorate(decorations);
    }

    @NotNull
    public static ServerAPITextComponent text(@NotNull Object text) {
        return new ServerAPITextComponent(String.valueOf(text));
    }

    @NotNull
    public static ServerAPITextComponent text(@NotNull Object text, @Nullable ServerAPITextColor color) {
        return (ServerAPITextComponent)ServerAPIComponent.text(text).color(color);
    }

    @NotNull
    public static ServerAPITextComponent text(@NotNull Object text, @Nullable ServerAPITextColor color, ServerAPITextDecoration ... decorations) {
        return (ServerAPITextComponent)ServerAPIComponent.text(text, color).decorate(decorations);
    }

    @NotNull
    public static ServerAPITextComponent empty() {
        return new ServerAPITextComponent("");
    }

    @NotNull
    public ServerAPIComponent append(@NotNull ServerAPIComponent var1);

    @NotNull
    public ServerAPIComponent append(int var1, @NotNull ServerAPIComponent var2);

    @NotNull
    public ServerAPIComponent remove(int var1);

    @NotNull
    public ServerAPIComponent replace(int var1, @NotNull ServerAPIComponent var2);

    @NotNull
    public ServerAPIComponent color(@Nullable ServerAPITextColor var1);

    @NotNull
    public ServerAPIComponent colorIfAbsent(@Nullable ServerAPITextColor var1);

    @NotNull
    public ServerAPIComponent decorate(@NotNull ServerAPITextDecoration var1);

    @NotNull
    public ServerAPIComponent decorate(ServerAPITextDecoration ... var1);

    @NotNull
    public ServerAPIComponent undecorate(@NotNull ServerAPITextDecoration var1);

    @NotNull
    public ServerAPIComponent undecorate(ServerAPITextDecoration ... var1);

    @NotNull
    public ServerAPIComponent unsetDecoration(@NotNull ServerAPITextDecoration var1);

    @NotNull
    public ServerAPIComponent unsetDecoration(ServerAPITextDecoration ... var1);

    @NotNull
    public ServerAPIComponent applyStyleFrom(@NotNull ServerAPIComponent var1);

    public boolean hasDecoration(@NotNull ServerAPITextDecoration var1);

    public boolean isDecorationSet(@NotNull ServerAPITextDecoration var1);

    public EnumMap<ServerAPITextDecoration, Boolean> getDecorations();

    public List<ServerAPIComponent> getChildren();

    @NotNull
    public ServerAPIComponent setChildren(@NotNull List<ServerAPIComponent> var1);

    @Nullable
    public ServerAPITextColor getColor();
}

