/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.model.component;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerAPITextColor {
    private static final Map<Integer, ServerAPITextColor> NAMED_VALUES = new HashMap<Integer, ServerAPITextColor>();
    private static final Map<String, ServerAPITextColor> NAMED = new HashMap<String, ServerAPITextColor>();
    public static final ServerAPITextColor BLACK = ServerAPITextColor.named("BLACK", 0);
    public static final ServerAPITextColor DARK_BLUE = ServerAPITextColor.named("DARK_BLUE", 170);
    public static final ServerAPITextColor DARK_GREEN = ServerAPITextColor.named("DARK_GREEN", 43520);
    public static final ServerAPITextColor DARK_AQUA = ServerAPITextColor.named("DARK_AQUA", 43690);
    public static final ServerAPITextColor DARK_RED = ServerAPITextColor.named("DARK_RED", 0xAA0000);
    public static final ServerAPITextColor DARK_PURPLE = ServerAPITextColor.named("DARK_PURPLE", 0xAA00AA);
    public static final ServerAPITextColor GOLD = ServerAPITextColor.named("GOLD", 0xFFAA00);
    public static final ServerAPITextColor GRAY = ServerAPITextColor.named("GRAY", 0xAAAAAA);
    public static final ServerAPITextColor DARK_GRAY = ServerAPITextColor.named("DARK_GRAY", 0x555555);
    public static final ServerAPITextColor BLUE = ServerAPITextColor.named("BLUE", 0x5555FF);
    public static final ServerAPITextColor GREEN = ServerAPITextColor.named("GREEN", 0x55FF55);
    public static final ServerAPITextColor AQUA = ServerAPITextColor.named("AQUA", 0x55FFFF);
    public static final ServerAPITextColor RED = ServerAPITextColor.named("RED", 0xFF5555);
    public static final ServerAPITextColor LIGHT_PURPLE = ServerAPITextColor.named("LIGHT_PURPLE", 0xFF55FF);
    public static final ServerAPITextColor YELLOW = ServerAPITextColor.named("YELLOW", 0xFFFF55);
    public static final ServerAPITextColor WHITE = ServerAPITextColor.named("WHITE", 0xFFFFFF);
    private final int value;

    private ServerAPITextColor(int value) {
        this.value = value;
    }

    @NotNull
    public static ServerAPITextColor of(int rgb) {
        return new ServerAPITextColor(rgb);
    }

    @NotNull
    public static ServerAPITextColor of(int red, int green, int blue) {
        return new ServerAPITextColor((red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
    }

    @NotNull
    public static ServerAPITextColor of(String hex) {
        return new ServerAPITextColor(Integer.parseInt(hex, 16));
    }

    @NotNull
    public static ServerAPITextColor of(int alpha, int red, int green, int blue) {
        return new ServerAPITextColor((alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
    }

    @NotNull
    public static ServerAPITextColor of(int alpha, int value) {
        return new ServerAPITextColor((alpha & 0xFF) << 24 | value);
    }

    @ApiStatus.Internal
    private static ServerAPITextColor named(String name, int value) {
        ServerAPITextColor color = new ServerAPITextColor(value);
        NAMED.put(name, color);
        NAMED_VALUES.put(value, color);
        return color;
    }

    @Nullable
    public static ServerAPITextColor getByName(String name) {
        return NAMED.get(name);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "ServerAPITextColor{value=" + this.value + '}';
    }
}

