/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.packet;

import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdentifiablePacket
implements Packet {
    private static int ID = 0;
    private int identifier = -1;

    protected IdentifiablePacket() {
        this.identifier = ID++;
        if (ID == Integer.MAX_VALUE) {
            ID = 0;
        }
    }

    protected IdentifiablePacket(@Nullable IdentifiablePacket initiator) {
        if (initiator == null) {
            return;
        }
        if (initiator == this) {
            throw new IllegalArgumentException("Initiator packet cannot be the same as the current packet");
        }
        this.identifier = initiator.getIdentifier();
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        this.identifier = reader.readVarInt();
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        writer.writeVarInt(this.identifier);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    @ApiStatus.Internal
    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        return "IdentifiablePacket{identifier=" + this.identifier + '}';
    }
}

