/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.payload;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PayloadChannelIdentifier {
    private final String combinedIdentifier;
    private final String namespace;
    private final String path;

    private PayloadChannelIdentifier(@NotNull String namespace, @NotNull String path) {
        Objects.requireNonNull(namespace, "Namespace cannot be null");
        Objects.requireNonNull(path, "Path cannot be null");
        this.namespace = namespace;
        this.path = path;
        this.combinedIdentifier = namespace + ":" + path;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static PayloadChannelIdentifier create(@NotNull String namespace, @NotNull String path) {
        return new PayloadChannelIdentifier(namespace, path);
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return this.combinedIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayloadChannelIdentifier that = (PayloadChannelIdentifier)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.path);
    }
}

