/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.api.payload.io;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextColor;
import net.labymod.serverapi.api.model.component.ServerAPITextComponent;
import net.labymod.serverapi.api.model.component.ServerAPITextDecoration;
import net.labymod.serverapi.api.payload.exception.PayloadReaderException;
import org.jetbrains.annotations.NotNull;

public class PayloadReader {
    private final ByteBuffer buffer;

    public PayloadReader() {
        this(ByteBuffer.allocate(255));
    }

    public PayloadReader(int capacity) {
        this(ByteBuffer.allocate(capacity));
    }

    public PayloadReader(byte @NotNull [] payload) {
        this(ByteBuffer.wrap(payload));
    }

    public PayloadReader(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int readVarInt() {
        try {
            byte currentByte;
            int result = 0;
            int bitOffset = 0;
            do {
                currentByte = this.buffer.get();
                result |= (currentByte & 0x7F) << bitOffset++ * 7;
                if (bitOffset <= 5) continue;
                throw new PayloadReaderException("VarInt is too big");
            } while ((currentByte & 0x80) == 128);
            return result;
        }
        catch (BufferUnderflowException exception) {
            throw new PayloadReaderException("The current position of the buffer is smaller than the limit.", exception);
        }
    }

    public String readString() {
        return this.readSizedString(Short.MAX_VALUE);
    }

    public String readSizedString(int maximumLength) {
        int length = this.readVarInt();
        if (length > maximumLength * 4) {
            throw new PayloadReaderException(String.format("The received encoded string buffer length is longer than maximum allowed (%s > %s)", length, maximumLength * 4));
        }
        if (length < 0) {
            throw new PayloadReaderException("The received encoded string buffer length is less than zero.");
        }
        byte[] data = new byte[length];
        try {
            this.buffer.get(data);
        }
        catch (BufferUnderflowException exception) {
            throw new PayloadReaderException(String.format("Could not read %s, %s remaining.", length, this.buffer.remaining()));
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    public boolean readBoolean() {
        return this.buffer.get() == 1;
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public byte[] readBytes(int length) {
        byte[] data = new byte[length];
        this.buffer.get(data);
        return data;
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public <T> List<T> readList(Supplier<T> reader) {
        int length = this.readVarInt();
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            T value = reader.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public <T> Set<T> readSet(Supplier<T> reader) {
        int length = this.readVarInt();
        HashSet<T> set = new HashSet<T>(length);
        for (int i = 0; i < length; ++i) {
            set.add(reader.get());
        }
        return set;
    }

    public <T> T[] readArray(Supplier<T> reader) {
        int length = this.readVarInt();
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = reader.get();
        }
        return array;
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public <T> T readOptional(Supplier<T> reader) {
        return this.readBoolean() ? (T)reader.get() : null;
    }

    public String[] readStringArray() {
        return this.readArray(this::readString);
    }

    public String readOptionalString() {
        return this.readOptional(this::readString);
    }

    public String[] readArray() {
        return this.readArray(this::readString);
    }

    public ServerAPIComponent readComponent() {
        byte id = this.readByte();
        ServerAPITextComponent component = id == 1 ? ServerAPIComponent.text(this.readString()) : ServerAPIComponent.empty();
        if (this.readBoolean()) {
            component.color(this.readOptional(() -> ServerAPITextColor.of(this.readInt())));
            List<ServerAPITextDecoration> decorations = ServerAPITextDecoration.getValues();
            int setDecorations = this.readVarInt();
            for (int i = 0; i < setDecorations; ++i) {
                byte ordinal = this.readByte();
                if (ordinal < 0 || ordinal >= decorations.size()) continue;
                ServerAPITextDecoration decoration = decorations.get(ordinal);
                if (this.readBoolean()) {
                    component.decorate(decoration);
                    continue;
                }
                component.undecorate(decoration);
            }
        }
        component.setChildren(this.readList(this::readComponent));
        return component;
    }

    public void reset() {
        this.buffer.position(0);
    }
}

