/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.api.packet.IdentifiablePacket;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.core.AbstractLabyModProtocolService;
import net.labymod.serverapi.core.LabyModProtocol;
import net.labymod.serverapi.core.integration.LabyModIntegrationPlayer;
import net.labymod.serverapi.core.integration.LabyModProtocolIntegration;
import net.labymod.serverapi.core.model.display.EconomyDisplay;
import net.labymod.serverapi.core.model.display.Subtitle;
import net.labymod.serverapi.core.model.display.TabListFlag;
import net.labymod.serverapi.core.model.feature.DiscordRPC;
import net.labymod.serverapi.core.model.feature.InteractionMenuEntry;
import net.labymod.serverapi.core.model.moderation.Permission;
import net.labymod.serverapi.core.model.moderation.RecommendedAddon;
import net.labymod.serverapi.core.model.supplement.InputPrompt;
import net.labymod.serverapi.core.model.supplement.ServerSwitchPrompt;
import net.labymod.serverapi.core.packet.clientbound.game.display.EconomyDisplayPacket;
import net.labymod.serverapi.core.packet.clientbound.game.display.SubtitlePacket;
import net.labymod.serverapi.core.packet.clientbound.game.display.TabListBannerPacket;
import net.labymod.serverapi.core.packet.clientbound.game.display.TabListFlagPacket;
import net.labymod.serverapi.core.packet.clientbound.game.feature.DiscordRPCPacket;
import net.labymod.serverapi.core.packet.clientbound.game.feature.InteractionMenuPacket;
import net.labymod.serverapi.core.packet.clientbound.game.feature.PlayingGameModePacket;
import net.labymod.serverapi.core.packet.clientbound.game.feature.marker.AddMarkerPacket;
import net.labymod.serverapi.core.packet.clientbound.game.feature.marker.MarkerPacket;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.AddonDisablePacket;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.AddonRecommendationPacket;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.PermissionPacket;
import net.labymod.serverapi.core.packet.clientbound.game.supplement.InputPromptPacket;
import net.labymod.serverapi.core.packet.clientbound.game.supplement.ServerSwitchPromptPacket;
import net.labymod.serverapi.core.packet.serverbound.game.moderation.AddonRecommendationResponsePacket;
import net.labymod.serverapi.core.packet.serverbound.game.supplement.InputPromptResponsePacket;
import net.labymod.serverapi.core.packet.serverbound.game.supplement.ServerSwitchPromptResponsePacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLabyModPlayer<P extends AbstractLabyModPlayer<?>> {
    protected final UUID uniqueId;
    protected final String labyModVersion;
    private final AbstractLabyModProtocolService protocolService;
    private final List<LabyModIntegrationPlayer> integrationPlayers = new ArrayList<LabyModIntegrationPlayer>();
    private final Map<String, EconomyDisplay> economies = new HashMap<String, EconomyDisplay>(2);
    private final List<String> disabledAddons = new ArrayList<String>();
    private Subtitle subtitle;
    private TabListFlag flag;

    protected AbstractLabyModPlayer(AbstractLabyModProtocolService protocolService, UUID uniqueId, String labyModVersion) {
        this.protocolService = protocolService;
        this.uniqueId = uniqueId;
        this.labyModVersion = labyModVersion;
        for (LabyModProtocolIntegration integration : protocolService.integrations) {
            LabyModIntegrationPlayer player = integration.createIntegrationPlayer(this);
            if (player == null) continue;
            Object existingPlayer = this.getIntegrationPlayer(player.getClass());
            if (existingPlayer == null) {
                this.integrationPlayers.add(player);
                continue;
            }
            protocolService.logger().warn("Tried to add integration player " + player + " (" + player.getClass().getName() + ") to " + uniqueId + " but it's already registered", new Object[0]);
        }
    }

    @Nullable
    public <T extends LabyModIntegrationPlayer> T getIntegrationPlayer(Class<T> clazz) {
        for (LabyModIntegrationPlayer integrationPlayer : this.integrationPlayers) {
            if (clazz != integrationPlayer.getClass()) continue;
            return (T)integrationPlayer;
        }
        return null;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @NotNull
    public String getLabyModVersion() {
        return this.labyModVersion;
    }

    @NotNull
    public Subtitle subtitle() {
        if (this.subtitle == null) {
            this.subtitle = Subtitle.create(this.uniqueId, null);
        }
        return this.subtitle;
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && this.subtitle.getText() != null;
    }

    public void updateSubtitle(@NotNull ServerAPIComponent text) {
        this.updateSubtitle((Subtitle subtitle) -> subtitle.text(text));
    }

    public void updateSubtitle(@NotNull ServerAPIComponent text, double size) {
        this.updateSubtitle((Subtitle subtitle) -> subtitle.text(text).size(size));
    }

    public void resetSubtitle() {
        this.updateSubtitle((Subtitle subtitle) -> subtitle.text(null));
    }

    public void updateSubtitle(Consumer<Subtitle> consumer) {
        if (this.subtitle == null) {
            this.subtitle = Subtitle.create(this.uniqueId, null);
        }
        ServerAPIComponent prevText = this.subtitle.getText();
        double prevSize = this.subtitle.getSize();
        consumer.accept(this.subtitle);
        if (this.subtitle.getSize() == prevSize && Objects.equals(prevText, this.subtitle.getText())) {
            return;
        }
        LabyModProtocol labyModProtocol = this.protocolService.labyModProtocol();
        SubtitlePacket packet = new SubtitlePacket(this.subtitle);
        for (AbstractLabyModPlayer abstractLabyModPlayer : this.protocolService.getPlayers()) {
            labyModProtocol.sendPacket(abstractLabyModPlayer.getUniqueId(), packet);
        }
    }

    public void disableAddons(List<String> addonsToDisable) {
        for (String addon : addonsToDisable) {
            if (this.disabledAddons.contains(addon)) continue;
            this.disabledAddons.add(addon);
        }
        this.sendPacket(AddonDisablePacket.disable(addonsToDisable));
    }

    public void disableAddons(String ... addonsToDisable) {
        this.disableAddons(Arrays.asList(addonsToDisable));
    }

    public void revertDisabledAddons(List<String> addonsToRevert) {
        for (String addon : addonsToRevert) {
            this.disabledAddons.remove(addon);
        }
        this.sendPacket(AddonDisablePacket.revert(addonsToRevert));
    }

    public void revertDisabledAddons(String ... addonsToRevert) {
        this.revertDisabledAddons(Arrays.asList(addonsToRevert));
    }

    public void revertDisabledAddons() {
        this.sendPacket(AddonDisablePacket.revert(this.disabledAddons));
        this.disabledAddons.clear();
    }

    public List<String> getDisabledAddons() {
        return this.disabledAddons;
    }

    public void sendMarkerSendType(MarkerPacket.MarkerSendType sendType) {
        this.sendPacket(new MarkerPacket(sendType));
    }

    public void sendMarker(@NotNull UUID sender, int x, int y, int z, boolean large, @Nullable UUID target) {
        this.sendPacket(new AddMarkerPacket(sender, x, y, z, large, target));
    }

    @Nullable
    public TabListFlag getTabListFlag() {
        return this.flag;
    }

    public void setTabListFlag(@NotNull TabListFlag.TabListFlagCountryCode countryCode) {
        this.flag = TabListFlag.create(this.uniqueId, countryCode);
        LabyModProtocol labyModProtocol = this.protocolService.labyModProtocol();
        TabListFlagPacket packet = new TabListFlagPacket(this.flag);
        for (AbstractLabyModPlayer abstractLabyModPlayer : this.protocolService.getPlayers()) {
            labyModProtocol.sendPacket(abstractLabyModPlayer.getUniqueId(), packet);
        }
    }

    @NotNull
    public EconomyDisplay bankEconomy() {
        return this.economies.computeIfAbsent("bank", EconomyDisplay::new);
    }

    @NotNull
    public EconomyDisplay cashEconomy() {
        return this.economies.computeIfAbsent("cash", EconomyDisplay::new);
    }

    @Nullable
    public EconomyDisplay getEconomy(@NotNull String key) {
        Objects.requireNonNull(key, "Key cannot be null");
        return this.economies.get(key);
    }

    public void updateEconomy(@NotNull String key, @NotNull Consumer<EconomyDisplay> consumer) {
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(consumer, "Consumer cannot be null");
        EconomyDisplay display = this.economies.computeIfAbsent(key, EconomyDisplay::new);
        consumer.accept(display);
        this.sendLabyModPacket(new EconomyDisplayPacket(display));
    }

    public void updateBankEconomy(@NotNull Consumer<EconomyDisplay> consumer) {
        this.updateEconomy("bank", consumer);
    }

    public void updateCashEconomy(@NotNull Consumer<EconomyDisplay> consumer) {
        this.updateEconomy("cash", consumer);
    }

    public void sendEconomy(EconomyDisplay display) {
        this.economies.put(display.getKey(), display);
        this.sendLabyModPacket(new EconomyDisplayPacket(display));
    }

    public void sendInteractionMenuEntries(InteractionMenuEntry ... entries) {
        this.sendLabyModPacket(new InteractionMenuPacket(entries));
    }

    public void sendInteractionMenuEntries(@NotNull List<InteractionMenuEntry> entries) {
        this.sendLabyModPacket(new InteractionMenuPacket(entries));
    }

    public void sendPlayingGameMode(@Nullable String gameMode) {
        this.sendLabyModPacket(new PlayingGameModePacket(gameMode));
    }

    public void sendDiscordRPC(@NotNull DiscordRPC discordRPC) {
        this.sendLabyModPacket(new DiscordRPCPacket(discordRPC));
    }

    public void sendTabListBanner(@Nullable String iconUrl) {
        this.sendLabyModPacket(new TabListBannerPacket(iconUrl));
    }

    public void sendPacket(@NotNull Packet packet) {
        Class<?> packetClass = packet.getClass();
        for (Protocol protocol : this.protocolService.registry().getProtocols()) {
            if (!protocol.hasPacket(packetClass)) continue;
            protocol.sendPacket(this.uniqueId, packet);
        }
    }

    public void sendPermissions(Permission.StatedPermission ... permissions) {
        this.sendLabyModPacket(new PermissionPacket(permissions));
    }

    public void sendPermissions(@NotNull List<Permission.StatedPermission> permissions) {
        this.sendLabyModPacket(new PermissionPacket(permissions));
    }

    public void openInputPrompt(@NotNull InputPrompt inputPrompt) {
        this.sendLabyModPacket(new InputPromptPacket(inputPrompt));
    }

    public void openInputPrompt(@NotNull InputPrompt inputPrompt, @NotNull Consumer<String> responseConsumer) {
        Objects.requireNonNull(responseConsumer, "Response consumer cannot be null");
        this.sendLabyModPacket(new InputPromptPacket(inputPrompt), InputPromptResponsePacket.class, response -> {
            responseConsumer.accept(response.getValue());
            return false;
        });
    }

    public void openServerSwitchPrompt(@NotNull ServerSwitchPrompt serverSwitchPrompt) {
        this.sendLabyModPacket(new ServerSwitchPromptPacket(serverSwitchPrompt));
    }

    public void openServerSwitchPrompt(@NotNull ServerSwitchPrompt serverSwitchPrompt, @NotNull Consumer<ServerSwitchPromptResponsePacket> responseConsumer) {
        Objects.requireNonNull(responseConsumer, "Response consumer cannot be null");
        this.sendLabyModPacket(new ServerSwitchPromptPacket(serverSwitchPrompt), ServerSwitchPromptResponsePacket.class, response -> {
            responseConsumer.accept((ServerSwitchPromptResponsePacket)response);
            return false;
        });
    }

    public void sendAddonRecommendations(@NotNull List<RecommendedAddon> addons) {
        this.sendLabyModPacket(new AddonRecommendationPacket(addons));
    }

    public void sendAddonRecommendations(RecommendedAddon ... addons) {
        this.sendLabyModPacket(new AddonRecommendationPacket(addons));
    }

    public void sendAddonRecommendations(@NotNull Consumer<AddonRecommendationResponsePacket> responseConsumer, RecommendedAddon ... addons) {
        this.sendAddonRecommendations(Arrays.asList(addons), responseConsumer);
    }

    public void sendAddonRecommendations(@NotNull List<RecommendedAddon> addons, @NotNull Consumer<AddonRecommendationResponsePacket> responseConsumer) {
        Objects.requireNonNull(responseConsumer, "Response consumer cannot be null");
        this.sendLabyModPacket(new AddonRecommendationPacket(addons), AddonRecommendationResponsePacket.class, response -> {
            responseConsumer.accept((AddonRecommendationResponsePacket)response);
            return response.isInitial();
        });
    }

    protected void sendLabyModPacket(@NotNull Packet packet) {
        this.protocolService.labyModProtocol.sendPacket(this.uniqueId, packet);
    }

    protected <T extends IdentifiablePacket> void sendLabyModPacket(@NotNull IdentifiablePacket packet, @NotNull Class<T> responseClass, @NotNull Predicate<T> responseConsumer) {
        this.protocolService.labyModProtocol.sendPacket(this.uniqueId, packet, responseClass, responseConsumer);
    }
}

