/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.labymod.serverapi.api.AbstractProtocolService;
import net.labymod.serverapi.core.AbstractLabyModPlayer;
import net.labymod.serverapi.core.LabyModProtocol;
import net.labymod.serverapi.core.integration.LabyModProtocolIntegration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLabyModProtocolService
extends AbstractProtocolService {
    protected final LabyModProtocol labyModProtocol;
    protected final Set<LabyModProtocolIntegration> integrations = new HashSet<LabyModProtocolIntegration>();

    protected AbstractLabyModProtocolService(@NotNull AbstractProtocolService.Side side) {
        super(side);
        this.labyModProtocol = new LabyModProtocol(this);
        this.registry().registerProtocol(this.labyModProtocol);
        this.loadLabyModProtocolIntegrations(null);
    }

    public final LabyModProtocol labyModProtocol() {
        return this.labyModProtocol;
    }

    @NotNull
    private ClassLoader getIntegrationClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Nullable
    public final <T extends LabyModProtocolIntegration> T getIntegration(@NotNull Class<T> integrationClass) {
        for (LabyModProtocolIntegration integration : this.integrations) {
            if (integration.getClass() != integrationClass) continue;
            return (T)integration;
        }
        return null;
    }

    @NotNull
    public final <T extends LabyModProtocolIntegration> T getOrRegisterIntegration(@NotNull Class<T> integrationClass, @NotNull @NotNull Supplier<@NotNull T> integrationSupplier) {
        Object integration = this.getIntegration(integrationClass);
        if (integration != null) {
            return integration;
        }
        integration = (LabyModProtocolIntegration)integrationSupplier.get();
        Objects.requireNonNull(integration, "integrationSupplier must not return null");
        integration.initialize(this);
        this.integrations.add((LabyModProtocolIntegration)integration);
        return integration;
    }

    protected void loadLabyModProtocolIntegrations(@Nullable ClassLoader classLoader) {
        ServiceLoader<LabyModProtocolIntegration> serviceLoader = classLoader == null ? ServiceLoader.load(LabyModProtocolIntegration.class, this.getIntegrationClassLoader()) : ServiceLoader.load(LabyModProtocolIntegration.class, classLoader);
        for (LabyModProtocolIntegration labyModProtocolIntegration : serviceLoader) {
            try {
                labyModProtocolIntegration.initialize(this);
                this.integrations.add(labyModProtocolIntegration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public AbstractLabyModPlayer getPlayer(@NotNull UUID uniqueId) {
        return null;
    }

    public boolean isUsingLabyMod(@NotNull UUID uniqueId) {
        return false;
    }

    public Collection<? extends AbstractLabyModPlayer> getPlayers() {
        return Collections.emptyList();
    }
}

