/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.display;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EconomyDisplay {
    private final String key;
    private boolean visible;
    private double balance;
    private String iconUrl;
    private DecimalFormat decimalFormat;

    public EconomyDisplay(@NotNull String key, boolean visible, double balance, @Nullable String iconUrl, @Nullable DecimalFormat decimalFormat) {
        Objects.requireNonNull(key, "Key must not be null");
        this.key = key;
        this.visible = visible;
        this.balance = balance;
        this.iconUrl = iconUrl;
        this.decimalFormat = decimalFormat;
    }

    public EconomyDisplay(@NotNull String key) {
        this(key, true, 0.0, null, null);
    }

    public EconomyDisplay(@NotNull String key, double balance) {
        this(key, true, balance, null, null);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public double getBalance() {
        return this.balance;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public EconomyDisplay visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public EconomyDisplay balance(double balance) {
        this.balance = balance;
        return this;
    }

    public EconomyDisplay iconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public EconomyDisplay decimalFormat(@Nullable DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EconomyDisplay)) {
            return false;
        }
        EconomyDisplay that = (EconomyDisplay)o;
        return this.visible == that.visible && Double.compare(this.balance, that.balance) == 0 && Objects.equals(this.key, that.key) && Objects.equals(this.iconUrl, that.iconUrl) && Objects.equals(this.decimalFormat, that.decimalFormat);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.visible, this.balance, this.iconUrl, this.decimalFormat);
    }

    public String toString() {
        return "EconomyDisplay{key='" + this.key + '\'' + ", visible=" + this.visible + ", balance=" + this.balance + ", iconUrl='" + this.iconUrl + '\'' + ", decimalFormat=" + this.decimalFormat + '}';
    }

    public static class DecimalFormat {
        private final String format;
        private final double divisor;

        public DecimalFormat(@NotNull String format, double divisor) {
            Objects.requireNonNull(format, "Format must not be null");
            this.format = format;
            this.divisor = divisor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DecimalFormat)) {
                return false;
            }
            DecimalFormat that = (DecimalFormat)o;
            return Double.compare(this.divisor, that.divisor) == 0 && Objects.equals(this.format, that.format);
        }

        public String getFormat() {
            return this.format;
        }

        public double getDivisor() {
            return this.divisor;
        }

        @Deprecated
        public String format() {
            return this.format;
        }

        @Deprecated
        public double divisor() {
            return this.divisor;
        }

        public int hashCode() {
            return Objects.hash(this.format, this.divisor);
        }

        public String toString() {
            return "DecimalFormat{format='" + this.format + '\'' + ", divisor=" + this.divisor + '}';
        }
    }
}

