/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.display;

import java.util.Objects;
import java.util.UUID;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Subtitle {
    private final UUID uniqueId;
    private ServerAPIComponent text;
    private double size;

    private Subtitle(@NotNull UUID uniqueId, @Nullable ServerAPIComponent text, double size) {
        Objects.requireNonNull(uniqueId, "UniqueId is null");
        this.uniqueId = uniqueId;
        this.text = text;
        this.size(size);
    }

    private Subtitle(@NotNull UUID uniqueId, @Nullable ServerAPIComponent text) {
        this(uniqueId, text, 1.0);
    }

    public static Subtitle create(@NotNull UUID uniqueId, @Nullable ServerAPIComponent text) {
        return new Subtitle(uniqueId, text);
    }

    public static Subtitle create(@NotNull UUID uniqueId, @Nullable ServerAPIComponent text, double size) {
        return new Subtitle(uniqueId, text, size);
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Nullable
    public ServerAPIComponent getText() {
        return this.text;
    }

    public double getSize() {
        return this.size;
    }

    public Subtitle size(double size) {
        if (size < 0.25) {
            size = 0.25;
        }
        if (size > 1.0) {
            size = 1.0;
        }
        this.size = size;
        return this;
    }

    public Subtitle text(@Nullable ServerAPIComponent text) {
        this.text = text;
        return this;
    }

    @Deprecated
    private void setSize(double size) {
        this.size(size);
    }

    public String toString() {
        return "Subtitle{uniqueId=" + this.uniqueId + ", text=" + this.text + ", size=" + this.size + '}';
    }
}

