/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.feature;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscordRPC {
    private static final DiscordRPC RESET = new DiscordRPC(null, 0L, 0L);
    private final String gameMode;
    private final long startTime;
    private final long endTime;

    protected DiscordRPC(@Nullable String gameMode, long startTime, long endTime) {
        if (startTime < 0L) {
            throw new IllegalArgumentException("startTime cannot be negative");
        }
        if (endTime < 0L) {
            throw new IllegalArgumentException("endTime cannot be negative");
        }
        this.gameMode = gameMode;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static DiscordRPC createReset() {
        return RESET;
    }

    public static DiscordRPC create(@NotNull String gameMode) {
        Objects.requireNonNull(gameMode, "GameMode cannot be null");
        return new DiscordRPC(gameMode, 0L, 0L);
    }

    public static DiscordRPC createWithStart(@NotNull String gameMode, long startTime) {
        Objects.requireNonNull(gameMode, "GameMode cannot be null");
        return new DiscordRPC(gameMode, startTime, 0L);
    }

    public static DiscordRPC createWithEnd(@NotNull String gameMode, long endTime) {
        Objects.requireNonNull(gameMode, "GameMode cannot be null");
        return new DiscordRPC(gameMode, 0L, endTime);
    }

    @Nullable
    public String getGameMode() {
        return this.gameMode;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean hasGameMode() {
        return this.gameMode != null;
    }

    public boolean hasStartTime() {
        return this.startTime != 0L;
    }

    public boolean hasEndTime() {
        return this.endTime != 0L;
    }

    public String toString() {
        return "DiscordRPC{gameMode='" + this.gameMode + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscordRPC)) {
            return false;
        }
        DiscordRPC that = (DiscordRPC)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && Objects.equals(this.gameMode, that.gameMode);
    }

    public int hashCode() {
        return Objects.hash(this.gameMode, this.startTime, this.endTime);
    }
}

