/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.feature;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class Emote {
    private final UUID uniqueId;
    private final int emoteId;

    protected Emote(@NotNull UUID uniqueId, int emoteId) {
        Objects.requireNonNull(uniqueId, "UniqueId is null");
        this.uniqueId = uniqueId;
        this.emoteId = emoteId;
    }

    public static Emote play(@NotNull UUID uniqueId, int emoteId) {
        return new Emote(uniqueId, emoteId);
    }

    public static Emote stop(@NotNull UUID uniqueId) {
        return new Emote(uniqueId, -1);
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public int getEmoteId() {
        return this.emoteId;
    }

    public boolean isStop() {
        return this.emoteId == -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Emote)) {
            return false;
        }
        Emote emote = (Emote)o;
        return this.emoteId == emote.emoteId && Objects.equals(this.uniqueId, emote.uniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.emoteId);
    }

    public String toString() {
        return "Emote{uniqueId=" + this.uniqueId + ", emoteId=" + this.emoteId + '}';
    }
}

