/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.feature;

import java.util.Objects;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractionMenuEntry {
    private final ServerAPIComponent displayName;
    private final InteractionMenuType type;
    private final String value;
    private final String iconUrl;

    protected InteractionMenuEntry(@NotNull ServerAPIComponent displayName, @NotNull InteractionMenuType type, @NotNull String value, @Nullable String iconUrl) {
        Objects.requireNonNull(displayName, "Display name cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        this.displayName = displayName;
        this.iconUrl = iconUrl;
        this.type = type;
        this.value = value;
    }

    public static InteractionMenuEntry create(@NotNull ServerAPIComponent displayName, @NotNull InteractionMenuType type, @NotNull String value, @Nullable String iconUrl) {
        return new InteractionMenuEntry(displayName, type, value, iconUrl);
    }

    public static InteractionMenuEntry create(@NotNull ServerAPIComponent displayName, @NotNull InteractionMenuType type, @NotNull String value) {
        return new InteractionMenuEntry(displayName, type, value, null);
    }

    @NotNull
    public ServerAPIComponent displayName() {
        return this.displayName;
    }

    @NotNull
    public InteractionMenuType type() {
        return this.type;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    public String toString() {
        return "InteractionMenuEntry{displayName=" + this.displayName + ", type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + ", iconUrl='" + this.iconUrl + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InteractionMenuEntry)) {
            return false;
        }
        InteractionMenuEntry that = (InteractionMenuEntry)o;
        return Objects.equals(this.displayName, that.displayName) && this.type == that.type && Objects.equals(this.value, that.value) && Objects.equals(this.iconUrl, that.iconUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayName, this.type, this.value, this.iconUrl});
    }

    public static enum InteractionMenuType {
        CLIPBOARD,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        OPEN_BROWSER;

        private static final InteractionMenuType[] VALUES;

        public static InteractionMenuType fromString(String type) {
            for (InteractionMenuType value : InteractionMenuType.values()) {
                if (!value.name().equalsIgnoreCase(type)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = InteractionMenuType.values();
        }
    }
}

