/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.moderation;

import java.util.Objects;

public class InstalledAddon {
    private final String namespace;
    private final AddonVersion version;
    private final boolean local;
    private boolean enabled;

    public InstalledAddon(String namespace, AddonVersion version, boolean enabled, boolean local) {
        this.namespace = namespace;
        this.version = version;
        this.enabled = enabled;
        this.local = local;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AddonVersion getVersion() {
        return this.version;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "Addon{namespace='" + this.namespace + '\'' + ", version=" + this.version + ", enabled=" + this.enabled + ", local=" + this.local + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstalledAddon)) {
            return false;
        }
        InstalledAddon that = (InstalledAddon)o;
        return Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.namespace);
    }

    public static class AddonVersion {
        private final int major;
        private final int minor;
        private final int patch;

        public AddonVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }
    }
}

