/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.moderation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Permission {
    private static final Map<String, Permission> PERMISSIONS = new HashMap<String, Permission>();
    public static final Permission CHAT_AUTOTEXT = Permission.of("chat_autotext");
    private final String identifier;
    private StatedPermission allowedPermission;
    private StatedPermission deniedPermission;

    protected Permission(@NotNull String identifier) {
        this.identifier = identifier;
    }

    public static Permission of(@NotNull String identifier) {
        Objects.requireNonNull(identifier, "Identifier");
        return PERMISSIONS.computeIfAbsent(identifier, Permission::new);
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public StatedPermission allow() {
        if (this.allowedPermission == null) {
            this.allowedPermission = new StatedPermission(this, true);
        }
        return this.allowedPermission;
    }

    public StatedPermission deny() {
        if (this.deniedPermission == null) {
            this.deniedPermission = new StatedPermission(this, false);
        }
        return this.deniedPermission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        return "Permission{identifier='" + this.identifier + '\'' + '}';
    }

    public static class StatedPermission {
        private final Permission permission;
        private final boolean allowed;

        private StatedPermission(@NotNull Permission permission, boolean allowed) {
            this.permission = permission;
            this.allowed = allowed;
        }

        @NotNull
        public Permission permission() {
            return this.permission;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        @Deprecated
        public boolean allowed() {
            return this.allowed;
        }

        public String toString() {
            return "StatedPermission{permission=" + this.permission + ", allowed=" + this.allowed + '}';
        }
    }
}

