/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.supplement;

import java.util.Objects;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputPrompt {
    private final ServerAPIComponent title;
    private final ServerAPIComponent placeholder;
    private final String defaultValue;
    private final int maxLength;

    protected InputPrompt(@NotNull ServerAPIComponent title, @Nullable ServerAPIComponent placeholder, @Nullable String defaultValue, int maxLength) {
        Objects.requireNonNull(title, "Title cannot be null");
        this.title = title;
        this.placeholder = placeholder;
        this.defaultValue = defaultValue;
        if (maxLength < 1) {
            maxLength = 100;
        }
        this.maxLength = maxLength;
    }

    public static InputPrompt create(@NotNull ServerAPIComponent title, @Nullable ServerAPIComponent placeholder, @Nullable String defaultValue, int maxLength) {
        return new InputPrompt(title, placeholder, defaultValue, maxLength);
    }

    public static InputPromptBuilder builder() {
        return new InputPromptBuilder();
    }

    @NotNull
    public ServerAPIComponent title() {
        return this.title;
    }

    @Nullable
    public ServerAPIComponent getPlaceholder() {
        return this.placeholder;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String toString() {
        return "InputPrompt{title=" + this.title + ", placeholder=" + this.placeholder + ", defaultValue='" + this.defaultValue + '\'' + ", maxLength=" + this.maxLength + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputPrompt)) {
            return false;
        }
        InputPrompt that = (InputPrompt)o;
        return this.maxLength == that.maxLength && Objects.equals(this.title, that.title) && Objects.equals(this.placeholder, that.placeholder) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.placeholder, this.defaultValue, this.maxLength);
    }

    public static class InputPromptBuilder {
        private ServerAPIComponent title;
        private ServerAPIComponent placeholder;
        private String defaultValue;
        private int maxLength;

        private InputPromptBuilder() {
        }

        public InputPromptBuilder title(@NotNull ServerAPIComponent title) {
            this.title = title;
            return this;
        }

        public InputPromptBuilder placeholder(@Nullable ServerAPIComponent placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public InputPromptBuilder defaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public InputPromptBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @NotNull
        public InputPrompt build() {
            return new InputPrompt(this.title, this.placeholder, this.defaultValue, this.maxLength);
        }
    }
}

