/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.model.supplement;

import java.util.Objects;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import org.jetbrains.annotations.NotNull;

public class ServerSwitchPrompt {
    private final ServerAPIComponent title;
    private final String address;
    private final boolean showPreview;

    protected ServerSwitchPrompt(@NotNull ServerAPIComponent title, @NotNull String address, boolean showPreview) {
        this.title = title;
        this.address = address;
        this.showPreview = showPreview;
    }

    public static ServerSwitchPrompt create(@NotNull ServerAPIComponent title, @NotNull String address, boolean showPreview) {
        return new ServerSwitchPrompt(title, address, showPreview);
    }

    public static ServerSwitchPrompt create(@NotNull ServerAPIComponent title, @NotNull String address) {
        return new ServerSwitchPrompt(title, address, true);
    }

    @NotNull
    public ServerAPIComponent title() {
        return this.title;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public String toString() {
        return "ServerSwitchPrompt{title=" + this.title + ", address='" + this.address + '\'' + ", showPreview=" + this.showPreview + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerSwitchPrompt)) {
            return false;
        }
        ServerSwitchPrompt that = (ServerSwitchPrompt)o;
        return this.showPreview == that.showPreview && Objects.equals(this.title, that.title) && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.address, this.showPreview);
    }
}

