/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.clientbound.game.display;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import net.labymod.serverapi.core.model.display.TabListFlag;
import org.jetbrains.annotations.NotNull;

public class TabListFlagPacket
implements Packet {
    private List<TabListFlag> flags;

    public TabListFlagPacket(List<TabListFlag> flags) {
        this.flags = flags;
    }

    public TabListFlagPacket(TabListFlag ... flags) {
        this.flags = Collections.unmodifiableList(Arrays.asList(flags));
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        this.flags = reader.readList(() -> TabListFlag.create(reader.readUUID(), reader.readString()));
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        writer.writeCollection(this.flags, flag -> {
            writer.writeUUID(flag.getUniqueId());
            writer.writeString(flag.getCountryCode().name());
        });
    }

    @NotNull
    public List<TabListFlag> getFlags() {
        return this.flags;
    }

    public String toString() {
        return "TabListFlagPacket{flags=" + this.flags + '}';
    }
}

