/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.clientbound.game.feature;

import java.util.Objects;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import net.labymod.serverapi.core.model.feature.DiscordRPC;
import org.jetbrains.annotations.NotNull;

public class DiscordRPCPacket
implements Packet {
    private DiscordRPC discordRPC;

    public DiscordRPCPacket(@NotNull DiscordRPC discordRPC) {
        Objects.requireNonNull(discordRPC, "DiscordRPC cannot be null");
        this.discordRPC = discordRPC;
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        long endTime;
        String gameMode = reader.readOptionalString();
        long startTime = reader.readBoolean() ? reader.readLong() : 0L;
        long l = endTime = reader.readBoolean() ? reader.readLong() : 0L;
        if (gameMode == null) {
            this.discordRPC = DiscordRPC.createReset();
            return;
        }
        this.discordRPC = startTime != 0L ? DiscordRPC.createWithStart(gameMode, startTime) : (endTime != 0L ? DiscordRPC.createWithEnd(gameMode, endTime) : DiscordRPC.create(gameMode));
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        writer.writeOptionalString(this.discordRPC.getGameMode());
        boolean hasStartTime = this.discordRPC.hasStartTime();
        writer.writeBoolean(hasStartTime);
        if (hasStartTime) {
            writer.writeLong(this.discordRPC.getStartTime());
        }
        boolean hasEndTime = this.discordRPC.hasEndTime();
        writer.writeBoolean(hasEndTime);
        if (hasEndTime) {
            writer.writeLong(this.discordRPC.getEndTime());
        }
    }

    public DiscordRPC discordRPC() {
        return this.discordRPC;
    }

    public String toString() {
        return "DiscordRPCPacket{discordRPC=" + this.discordRPC + '}';
    }
}

