/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.clientbound.game.feature.marker;

import java.util.Objects;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.NotNull;

public class MarkerPacket
implements Packet {
    private MarkerSendType type;

    public MarkerPacket(@NotNull MarkerSendType type) {
        Objects.requireNonNull(type, "Type must not be null");
        this.type = type;
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        String rawType = reader.readString();
        this.type = MarkerSendType.fromString(rawType);
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid marker send type " + rawType);
        }
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        writer.writeString((Object)this.type);
    }

    @NotNull
    public MarkerSendType type() {
        return this.type;
    }

    public String toString() {
        return "MarkerPacket{type=" + (Object)((Object)this.type) + '}';
    }

    public static enum MarkerSendType {
        SERVER,
        LABY_CONNECT;

        private static final MarkerSendType[] VALUES;

        public static MarkerSendType fromString(String name) {
            for (MarkerSendType value : VALUES) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = MarkerSendType.values();
        }
    }
}

