/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.clientbound.game.moderation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.NotNull;

public class AddonDisablePacket
implements Packet {
    private List<String> addonsToDisable;
    private Action action;

    protected AddonDisablePacket(@NotNull Action action, @NotNull List<String> addonsToDisable) {
        Objects.requireNonNull(addonsToDisable, "Addons to disable cannot be null");
        Objects.requireNonNull(action, "Action cannot be null");
        this.action = action;
        this.addonsToDisable = addonsToDisable;
    }

    protected AddonDisablePacket(@NotNull Action action, String ... addonsToDisable) {
        this(action, Collections.unmodifiableList(Arrays.asList(addonsToDisable)));
    }

    public static AddonDisablePacket disable(@NotNull List<String> addonsToDisable) {
        return new AddonDisablePacket(Action.DISABLE, addonsToDisable);
    }

    public static AddonDisablePacket revert(@NotNull List<String> addonsToRevert) {
        return new AddonDisablePacket(Action.REVERT, addonsToRevert);
    }

    public static AddonDisablePacket disable(String ... addonsToDisable) {
        return new AddonDisablePacket(Action.DISABLE, addonsToDisable);
    }

    public static AddonDisablePacket revert(String ... addonsToRevert) {
        return new AddonDisablePacket(Action.REVERT, addonsToRevert);
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        this.action = reader.readBoolean() ? Action.DISABLE : Action.REVERT;
        this.addonsToDisable = reader.readList(reader::readString);
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        writer.writeBoolean(this.action == Action.DISABLE);
        writer.writeCollection(this.addonsToDisable, writer::writeString);
    }

    @NotNull
    public List<String> getAddonsToDisable() {
        return this.addonsToDisable;
    }

    @NotNull
    public Action action() {
        return this.action;
    }

    public String toString() {
        return "AddonDisablePacket{addonsToDisable=" + this.addonsToDisable + ", action=" + (Object)((Object)this.action) + '}';
    }

    public static enum Action {
        DISABLE,
        REVERT;

    }
}

