/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.clientbound.game.moderation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.labymod.serverapi.api.packet.IdentifiablePacket;
import net.labymod.serverapi.api.packet.OnlyWriteConstructor;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import org.jetbrains.annotations.NotNull;

public class InstalledAddonsRequestPacket
extends IdentifiablePacket {
    private List<String> addonsToRequest;

    public InstalledAddonsRequestPacket(@NotNull List<String> addonsToRequest) {
        Objects.requireNonNull(addonsToRequest, "Addons cannot be null");
        this.addonsToRequest = addonsToRequest;
    }

    public InstalledAddonsRequestPacket(String ... addonsToRequest) {
        this(Collections.unmodifiableList(Arrays.asList(addonsToRequest)));
    }

    @OnlyWriteConstructor
    public InstalledAddonsRequestPacket() {
        this(Collections.emptyList());
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        super.read(reader);
        this.addonsToRequest = reader.readList(reader::readString);
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        super.write(writer);
        writer.writeCollection(this.addonsToRequest, writer::writeString);
    }

    @NotNull
    public List<String> getAddonsToRequest() {
        return this.addonsToRequest;
    }

    public boolean requestsAllAddons() {
        return this.addonsToRequest.isEmpty();
    }

    @Override
    public String toString() {
        return "EnabledAddonsRequestPacket{addonsToRequest=" + this.addonsToRequest + "} " + super.toString();
    }
}

