/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.serverbound.game.moderation;

import java.util.List;
import net.labymod.serverapi.api.packet.IdentifiablePacket;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.AddonRecommendationPacket;
import org.jetbrains.annotations.NotNull;

public class AddonRecommendationResponsePacket
extends IdentifiablePacket {
    private boolean initial;
    private boolean allInstalled;
    private List<String> missingAddons;
    private List<String> installedAddons;

    protected AddonRecommendationResponsePacket() {
        super(null);
    }

    public AddonRecommendationResponsePacket(@NotNull AddonRecommendationPacket initiator, boolean initial, boolean allInstalled, @NotNull List<String> missingAddons, @NotNull List<String> installedAddons) {
        super(initiator);
        this.initial = initial;
        this.allInstalled = allInstalled;
        this.missingAddons = missingAddons;
        this.installedAddons = installedAddons;
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        super.read(reader);
        this.initial = reader.readBoolean();
        this.allInstalled = reader.readBoolean();
        this.missingAddons = reader.readList(reader::readString);
        this.installedAddons = reader.readList(reader::readString);
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        super.write(writer);
        writer.writeBoolean(this.initial);
        writer.writeBoolean(this.allInstalled);
        writer.writeCollection(this.missingAddons, writer::writeString);
        writer.writeCollection(this.installedAddons, writer::writeString);
    }

    public boolean isInitial() {
        return this.initial;
    }

    public boolean isAllInstalled() {
        return this.allInstalled;
    }

    @NotNull
    public List<String> getMissingAddons() {
        return this.missingAddons;
    }

    @NotNull
    public List<String> getInstalledAddons() {
        return this.installedAddons;
    }
}

