/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.core.packet.serverbound.game.moderation;

import java.util.List;
import java.util.Objects;
import net.labymod.serverapi.api.packet.IdentifiablePacket;
import net.labymod.serverapi.api.payload.io.PayloadReader;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import net.labymod.serverapi.core.model.moderation.InstalledAddon;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.InstalledAddonsRequestPacket;
import org.jetbrains.annotations.NotNull;

public class InstalledAddonsResponsePacket
extends IdentifiablePacket {
    private List<InstalledAddon> installedAddons;

    protected InstalledAddonsResponsePacket() {
        super(null);
    }

    public InstalledAddonsResponsePacket(@NotNull InstalledAddonsRequestPacket initiator, @NotNull List<InstalledAddon> installedAddons) {
        super(initiator);
        Objects.requireNonNull(installedAddons, "Installed Addons cannot be null");
        this.installedAddons = installedAddons;
    }

    static InstalledAddon readInstalledAddon(PayloadReader reader) {
        return new InstalledAddon(reader.readString(), new InstalledAddon.AddonVersion(reader.readVarInt(), reader.readVarInt(), reader.readVarInt()), reader.readBoolean(), reader.readBoolean());
    }

    static void writeInstalledAddon(PayloadWriter writer, InstalledAddon installedAddon) {
        writer.writeString(installedAddon.getNamespace());
        writer.writeVarInt(installedAddon.getVersion().getMajor());
        writer.writeVarInt(installedAddon.getVersion().getMinor());
        writer.writeVarInt(installedAddon.getVersion().getPatch());
        writer.writeBoolean(installedAddon.isEnabled());
        writer.writeBoolean(installedAddon.isLocal());
    }

    @Override
    public void read(@NotNull PayloadReader reader) {
        super.read(reader);
        this.installedAddons = reader.readList(() -> InstalledAddonsResponsePacket.readInstalledAddon(reader));
    }

    @Override
    public void write(@NotNull PayloadWriter writer) {
        super.write(writer);
        writer.writeCollection(this.installedAddons, addon -> InstalledAddonsResponsePacket.writeInstalledAddon(writer, addon));
    }

    @NotNull
    public List<InstalledAddon> getInstalledAddons() {
        return this.installedAddons;
    }

    @Override
    public String toString() {
        return "InstalledAddonsResponsePacket{installedAddons=" + this.installedAddons + "} " + super.toString();
    }
}

