/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.integration.voicechat.model;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoiceChatMute {
    private final UUID uniqueId;
    private final String reason;
    private final long end;

    private VoiceChatMute(@NotNull UUID uniqueId, @Nullable String reason, long end) {
        Objects.requireNonNull(uniqueId, "uniqueId cannot be null");
        if (end < 0L) {
            throw new IllegalArgumentException("end cannot be negative");
        }
        this.uniqueId = uniqueId;
        this.reason = reason;
        this.end = end;
    }

    @NotNull
    public static VoiceChatMute create(@NotNull UUID uniqueId, @Nullable String reason, long end) {
        return new VoiceChatMute(uniqueId, reason, end);
    }

    @NotNull
    public static VoiceChatMute create(@NotNull UUID uniqueId, @Nullable String reason) {
        return VoiceChatMute.create(uniqueId, reason, 0L);
    }

    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isPermanent() {
        return this.end == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VoiceChatMute)) {
            return false;
        }
        VoiceChatMute that = (VoiceChatMute)o;
        return this.end == that.end && Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.reason, this.end);
    }

    public String toString() {
        return "VoiceChatMute{uniqueId=" + this.uniqueId + ", reason='" + this.reason + '\'' + ", end=" + this.end + '}';
    }
}

