/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.bukkit;

import java.util.Objects;
import java.util.UUID;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.api.logger.NoOpProtocolPlatformLogger;
import net.labymod.serverapi.api.logger.ProtocolPlatformLogger;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.api.payload.PayloadChannelIdentifier;
import net.labymod.serverapi.api.payload.io.PayloadWriter;
import net.labymod.serverapi.core.packet.serverbound.login.VersionLoginPacket;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.event.LabyModInstalledAddonsUpdateEvent;
import net.labymod.serverapi.server.bukkit.event.LabyModPacketReceivedEvent;
import net.labymod.serverapi.server.bukkit.event.LabyModPacketSentEvent;
import net.labymod.serverapi.server.bukkit.handler.DefaultVersionLoginPacketHandler;
import net.labymod.serverapi.server.bukkit.listener.DefaultPlayerQuitListener;
import net.labymod.serverapi.server.bukkit.listener.DefaultPluginMessageListener;
import net.labymod.serverapi.server.common.AbstractServerLabyModProtocolService;
import net.labymod.serverapi.server.common.JavaProtocolLogger;
import net.labymod.serverapi.server.common.model.player.AbstractServerLabyModPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LabyModProtocolService
extends AbstractServerLabyModProtocolService<LabyModPlayer> {
    private static final LabyModProtocolService INSTANCE = new LabyModProtocolService();
    private ProtocolPlatformLogger logger = NoOpProtocolPlatformLogger.get();
    private JavaPlugin plugin;

    private LabyModProtocolService() {
    }

    public static LabyModProtocolService get() {
        return INSTANCE;
    }

    public static void initialize(@NotNull JavaPlugin javaPlugin) {
        LabyModProtocolService.get().initializePlugin(javaPlugin);
    }

    @Override
    public void afterPacketHandled(@NotNull Protocol protocol, @NotNull Packet packet, @NotNull UUID sender) {
        if (this.plugin != null) {
            this.plugin.getServer().getPluginManager().callEvent((Event)new LabyModPacketReceivedEvent(this, protocol, sender, packet));
        }
    }

    @Override
    public void afterPacketSent(@NotNull Protocol protocol, @NotNull Packet packet, @NotNull UUID recipient) {
        if (this.plugin != null) {
            this.plugin.getServer().getPluginManager().callEvent((Event)new LabyModPacketSentEvent(this, protocol, recipient, packet));
        }
    }

    @Override
    public void send(@NotNull PayloadChannelIdentifier identifier, @NotNull UUID recipient, @NotNull PayloadWriter writer) {
        Objects.requireNonNull(identifier, "Identifier cannot be null");
        Objects.requireNonNull(recipient, "Recipient cannot be null");
        Objects.requireNonNull(writer, "Writer cannot be null");
        if (this.plugin == null) {
            throw new IllegalStateException("The plugin instance is not set yet");
        }
        Player player = this.plugin.getServer().getPlayer(recipient);
        if (player == null) {
            return;
        }
        player.sendPluginMessage((Plugin)this.plugin, identifier.toString(), writer.toByteArray());
    }

    @Override
    @NotNull
    public ProtocolPlatformLogger logger() {
        return this.logger;
    }

    @Override
    public boolean isInitialized() {
        return this.plugin != null;
    }

    @Override
    @ApiStatus.Internal
    public void handleInstalledAddonsUpdate(AbstractServerLabyModPlayer<?, ?> labyModPlayer) {
        if (this.plugin != null) {
            this.plugin.getServer().getPluginManager().callEvent((Event)new LabyModInstalledAddonsUpdateEvent(this, (LabyModPlayer)labyModPlayer));
        }
    }

    private void initializePlugin(@NotNull JavaPlugin javaPlugin) {
        Objects.requireNonNull(javaPlugin, "JavaPlugin cannot be null");
        if (this.plugin != null) {
            throw new IllegalStateException("The plugin instance is already set");
        }
        this.plugin = javaPlugin;
        this.logger = new JavaProtocolLogger(javaPlugin.getLogger());
        Messenger messenger = this.plugin.getServer().getMessenger();
        this.registry().addRegisterListener(protocol -> {
            String identifier = protocol.identifier().toString();
            messenger.registerOutgoingPluginChannel((Plugin)this.plugin, identifier);
            messenger.registerIncomingPluginChannel((Plugin)this.plugin, identifier, (PluginMessageListener)new DefaultPluginMessageListener((Protocol)protocol));
        });
        this.initializeManaged();
    }

    private void initializeManaged() {
        this.labyModProtocol.registerHandler(VersionLoginPacket.class, new DefaultVersionLoginPacketHandler(this, this.plugin));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new DefaultPlayerQuitListener(this), (Plugin)this.plugin);
    }
}

