/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.bukkit.event;

import java.util.UUID;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.LabyModProtocolService;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabyModPacketSentEvent
extends Event {
    private static final HandlerList handlerList = new HandlerList();
    private final LabyModProtocolService protocolService;
    private final Protocol protocol;
    private final UUID receiver;
    private final Packet packet;

    public LabyModPacketSentEvent(@NotNull LabyModProtocolService protocolService, @NotNull Protocol protocol, @NotNull UUID receiver, @NotNull Packet packet) {
        this.protocolService = protocolService;
        this.protocol = protocol;
        this.receiver = receiver;
        this.packet = packet;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public LabyModProtocolService protocolService() {
        return this.protocolService;
    }

    @Nullable
    public LabyModPlayer getLabyModPlayer() {
        return (LabyModPlayer)this.protocolService.getPlayer(this.receiver);
    }

    @NotNull
    public Protocol protocol() {
        return this.protocol;
    }

    @NotNull
    public UUID getReceiver() {
        return this.receiver;
    }

    @NotNull
    public Packet packet() {
        return this.packet;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlerList;
    }

    public String toString() {
        return "LabyModPacketSentEvent{, protocol=" + this.protocol.identifier() + ", receiver=" + this.receiver + ", packet=" + this.packet + "}";
    }
}

