/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.bukkit.handler;

import java.util.UUID;
import net.labymod.serverapi.api.packet.PacketHandler;
import net.labymod.serverapi.core.packet.serverbound.login.VersionLoginPacket;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.LabyModProtocolService;
import net.labymod.serverapi.server.bukkit.event.LabyModPlayerJoinEvent;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DefaultVersionLoginPacketHandler
implements PacketHandler<VersionLoginPacket> {
    private final LabyModProtocolService protocolService;
    private final JavaPlugin javaPlugin;

    public DefaultVersionLoginPacketHandler(LabyModProtocolService protocolService, JavaPlugin javaPlugin) {
        this.protocolService = protocolService;
        this.javaPlugin = javaPlugin;
    }

    @Override
    public void handle(@NotNull UUID uuid, @NotNull VersionLoginPacket versionLoginPacket) {
        if (this.protocolService.getPlayer(uuid) != null) {
            return;
        }
        Server server = this.javaPlugin.getServer();
        Player player = server.getPlayer(uuid);
        if (player == null) {
            return;
        }
        LabyModPlayer labyModPlayer = new LabyModPlayer(this.protocolService, uuid, player, versionLoginPacket.getVersion());
        this.protocolService.handlePlayerJoin(labyModPlayer);
        server.getPluginManager().callEvent((Event)new LabyModPlayerJoinEvent(this.protocolService, labyModPlayer));
    }
}

