/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.labymod.serverapi.api.AbstractProtocolService;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.core.AbstractLabyModPlayer;
import net.labymod.serverapi.core.AbstractLabyModProtocolService;
import net.labymod.serverapi.core.model.display.Subtitle;
import net.labymod.serverapi.core.model.display.TabListFlag;
import net.labymod.serverapi.core.packet.clientbound.game.display.SubtitlePacket;
import net.labymod.serverapi.core.packet.clientbound.game.display.TabListFlagPacket;
import net.labymod.serverapi.core.packet.serverbound.game.moderation.AddonStateChangedPacket;
import net.labymod.serverapi.core.packet.serverbound.game.moderation.InstalledAddonsResponsePacket;
import net.labymod.serverapi.server.common.handler.DefaultAddonStateChangedPacketHandler;
import net.labymod.serverapi.server.common.handler.DefaultInstalledAddonsResponsePacketHandler;
import net.labymod.serverapi.server.common.model.player.AbstractServerLabyModPlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractServerLabyModProtocolService<T extends AbstractServerLabyModPlayer>
extends AbstractLabyModProtocolService {
    protected final Map<UUID, T> players = new HashMap<UUID, T>();

    protected AbstractServerLabyModProtocolService() {
        super(AbstractProtocolService.Side.SERVER);
        this.registerDefaultHandlers();
    }

    @Nullable
    public T getPlayer(@NotNull UUID uniqueId) {
        return (T)((AbstractServerLabyModPlayer)this.players.get(uniqueId));
    }

    @Override
    public boolean isUsingLabyMod(@NotNull UUID uniqueId) {
        return this.players.containsKey(uniqueId);
    }

    public Collection<T> getPlayers() {
        return this.players.values();
    }

    public void forEachPlayer(@NotNull Consumer<T> action) {
        for (AbstractServerLabyModPlayer value : this.players.values()) {
            action.accept(value);
        }
    }

    @ApiStatus.Internal
    public void handlePlayerQuit(@NotNull UUID uniqueId) {
        this.players.remove(uniqueId);
        for (Protocol protocol : this.registry().getProtocols()) {
            protocol.clearAwaitingResponsesFor(uniqueId);
        }
    }

    @ApiStatus.Internal
    public void handlePlayerJoin(@NotNull T labyModPlayer) {
        this.players.put(((AbstractLabyModPlayer)labyModPlayer).getUniqueId(), labyModPlayer);
        ArrayList<Subtitle> subtitles = new ArrayList<Subtitle>();
        ArrayList<TabListFlag> flags = new ArrayList<TabListFlag>();
        this.forEachPlayer(player -> {
            TabListFlag tabListFlag;
            if (player.hasSubtitle()) {
                subtitles.add(player.subtitle());
            }
            if ((tabListFlag = player.getTabListFlag()) != null) {
                flags.add(tabListFlag);
            }
        });
        if (!subtitles.isEmpty()) {
            this.labyModProtocol.sendPacket(((AbstractLabyModPlayer)labyModPlayer).getUniqueId(), new SubtitlePacket(subtitles));
        }
        if (!flags.isEmpty()) {
            this.labyModProtocol.sendPacket(((AbstractLabyModPlayer)labyModPlayer).getUniqueId(), new TabListFlagPacket(flags));
        }
    }

    @ApiStatus.Internal
    public abstract void handleInstalledAddonsUpdate(AbstractServerLabyModPlayer<?, ?> var1);

    protected void registerDefaultHandlers() {
        this.labyModProtocol.registerHandler(AddonStateChangedPacket.class, new DefaultAddonStateChangedPacketHandler(this));
        this.labyModProtocol.registerHandler(InstalledAddonsResponsePacket.class, new DefaultInstalledAddonsResponsePacketHandler(this));
    }
}

