/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.common.model.addon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.labymod.serverapi.core.model.moderation.InstalledAddon;
import net.labymod.serverapi.core.packet.serverbound.game.moderation.InstalledAddonsResponsePacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledAddonsResponse {
    private final Map<String, InstalledAddon> installedAddons = new HashMap<String, InstalledAddon>();
    private boolean hasResponse;
    private boolean hasRequested;
    private List<String> requestedAddons = new ArrayList<String>();

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public boolean hasRequested() {
        return this.hasRequested;
    }

    public List<String> getRequested() {
        return this.requestedAddons;
    }

    @Nullable
    public InstalledAddon get(String namespace) {
        return this.installedAddons.get(namespace);
    }

    public boolean isInstalled(String namespace) {
        return this.get(namespace) != null;
    }

    @NotNull
    public Collection<InstalledAddon> getInstalledAddons() {
        return this.installedAddons.values();
    }

    public boolean isEnabled(String namespace) {
        InstalledAddon installedAddon = this.get(namespace);
        return installedAddon != null && installedAddon.isEnabled();
    }

    public boolean isDisabled(String namespace) {
        InstalledAddon installedAddon = this.get(namespace);
        return installedAddon != null && !installedAddon.isEnabled();
    }

    @Nullable
    public InstalledAddon.AddonVersion getVersion(String namespace) {
        InstalledAddon installedAddon = this.get(namespace);
        return installedAddon != null ? installedAddon.getVersion() : null;
    }

    public boolean isLocal(String namespace) {
        InstalledAddon installedAddon = this.get(namespace);
        return installedAddon != null && installedAddon.isLocal();
    }

    @ApiStatus.Internal
    public void handleResponse(InstalledAddonsResponsePacket packet) {
        for (InstalledAddon installedAddon : packet.getInstalledAddons()) {
            this.installedAddons.put(installedAddon.getNamespace(), installedAddon);
        }
        this.hasResponse = true;
    }

    @ApiStatus.Internal
    public void setRequestedAddons(@NotNull List<String> requestedAddons) {
        if (this.hasRequested) {
            if (this.requestedAddons.isEmpty()) {
                return;
            }
            if (requestedAddons.isEmpty()) {
                this.requestedAddons.clear();
                return;
            }
            boolean addedRequest = false;
            for (String requestedAddon : requestedAddons) {
                if (this.requestedAddons.contains(requestedAddon)) continue;
                this.requestedAddons.add(requestedAddon);
                addedRequest = true;
            }
            if (addedRequest) {
                return;
            }
        }
        this.hasRequested = true;
        this.requestedAddons = requestedAddons;
    }

    @ApiStatus.Internal
    public void updateAddon(InstalledAddon installedAddon) {
        this.installedAddons.put(installedAddon.getNamespace(), installedAddon);
    }

    public String toString() {
        return "InstalledAddonsResponse{installedAddons=" + this.installedAddons + ", hasResponse=" + this.hasResponse + ", hasRequested=" + this.hasRequested + ", requestedAddons=" + this.requestedAddons + '}';
    }
}

