/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.server.common.model.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.labymod.serverapi.core.AbstractLabyModPlayer;
import net.labymod.serverapi.core.packet.clientbound.game.moderation.InstalledAddonsRequestPacket;
import net.labymod.serverapi.core.packet.serverbound.game.moderation.InstalledAddonsResponsePacket;
import net.labymod.serverapi.server.common.AbstractServerLabyModProtocolService;
import net.labymod.serverapi.server.common.model.addon.InstalledAddonsResponse;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractServerLabyModPlayer<P extends AbstractServerLabyModPlayer<?, ?>, T>
extends AbstractLabyModPlayer<P> {
    private final T serverPlayer;
    private final InstalledAddonsResponse installedAddonsResponse;

    protected AbstractServerLabyModPlayer(AbstractServerLabyModProtocolService<?> protocolService, UUID uniqueId, T player, String labyModVersion) {
        super(protocolService, uniqueId, labyModVersion);
        this.serverPlayer = player;
        this.installedAddonsResponse = new InstalledAddonsResponse();
    }

    public T getPlayer() {
        return this.serverPlayer;
    }

    @NotNull
    public InstalledAddonsResponse installedAddons() {
        return this.installedAddonsResponse;
    }

    public void requestInstalledAddons() {
        this.requestInstalledAddons(new ArrayList<String>(), null);
    }

    public void requestInstalledAddons(Consumer<InstalledAddonsResponse> response) {
        this.requestInstalledAddons(new ArrayList<String>(), response);
    }

    public void requestInstalledAddons(String ... addonsToRequest) {
        this.requestInstalledAddons(Arrays.asList(addonsToRequest), null);
    }

    public void requestInstalledAddons(@NotNull List<String> addonsToRequest) {
        this.requestInstalledAddons(addonsToRequest, null);
    }

    public void requestInstalledAddons(Consumer<InstalledAddonsResponse> response, String ... addonsToRequest) {
        this.requestInstalledAddons(Arrays.asList(addonsToRequest), response);
    }

    public void requestInstalledAddons(@NotNull List<String> addonsToRequest, Consumer<InstalledAddonsResponse> response) {
        this.installedAddonsResponse.setRequestedAddons(addonsToRequest);
        this.sendLabyModPacket(new InstalledAddonsRequestPacket(addonsToRequest), InstalledAddonsResponsePacket.class, packet -> {
            this.installedAddonsResponse.handleResponse((InstalledAddonsResponsePacket)packet);
            if (response != null) {
                response.accept(this.installedAddonsResponse);
            }
            return false;
        });
    }
}

