/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.gameclock;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import java.awt.Point;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Config {
    public static ConfigClassHandler<Config> HANDLER = ConfigClassHandler.createBuilder(Config.class).id(ResourceLocation.tryBuild((String)"gameclock", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(YACLPlatform.getConfigDir().resolve("gameclock.json5")).setJson5(true).build()).build();
    @SerialEntry
    public Position guiPosition = Position.BOTTOM_LEFT;
    @SerialEntry
    public Boolean shadowText = true;
    @SerialEntry(value="hexColor", comment="I messed up naming it hexcolor in v1 (this is text color)")
    public Color textColor = new Color(-1, true);
    @SerialEntry
    public int xPadding = 5;
    @SerialEntry
    public int yPadding = 5;
    @SerialEntry
    public boolean is24Hour = false;
    @SerialEntry
    public boolean enableTextBackground = false;
    @SerialEntry
    public Color backgroundColor = new Color(-1873784752, true);
    @SerialEntry
    public boolean showSeconds = false;
    @SerialEntry
    boolean leadZero = false;
    private String builtFormat;

    public void buildFormat() {
        StringBuilder formatBuilder = new StringBuilder();
        formatBuilder.append(this.leadZero ? (this.is24Hour ? "HH" : "hh") : (this.is24Hour ? "H" : "h")).append(":mm");
        if (this.showSeconds) {
            formatBuilder.append(":ss");
        }
        if (!this.is24Hour) {
            formatBuilder.append(" a");
        }
        this.builtFormat = formatBuilder.toString();
    }

    public String getTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(this.builtFormat));
    }

    public Point calculatePosition(GuiGraphics ctx, String str, Font font) {
        int textWidth = font.width(str);
        return switch (this.guiPosition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> new Point(this.xPadding, this.yPadding);
            case 3 -> {
                int v1 = ctx.guiHeight();
                Objects.requireNonNull(font);
                yield new Point(this.xPadding, v1 - 9 - this.yPadding);
            }
            case 0 -> new Point(ctx.guiWidth() - textWidth - this.xPadding, this.yPadding);
            case 1 -> {
                int v2 = ctx.guiWidth() - textWidth - this.xPadding;
                int v3 = ctx.guiHeight();
                Objects.requireNonNull(font);
                yield new Point(v2, v3 - 9 - this.yPadding);
            }
        };
    }

    public PointCollection calculatePositions(GuiGraphics ctx, String str, Font font) {
        int textWidth = font.width(str);
        return switch (this.guiPosition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> {
                Point v0 = new Point(this.xPadding, this.yPadding);
                Objects.requireNonNull(font);
                yield new PointCollection(v0, new Point(this.xPadding + textWidth, this.yPadding + 9));
            }
            case 3 -> {
                int v2 = ctx.guiHeight();
                Objects.requireNonNull(font);
                yield new PointCollection(new Point(this.xPadding, v2 - 9 - this.yPadding), new Point(this.xPadding + textWidth, ctx.guiHeight() - this.yPadding));
            }
            case 0 -> {
                Point v3 = new Point(ctx.guiWidth() - textWidth - this.xPadding, this.yPadding);
                int v4 = ctx.guiWidth() - this.xPadding;
                Objects.requireNonNull(font);
                yield new PointCollection(v3, new Point(v4, this.yPadding + 9));
            }
            case 1 -> {
                int v5 = ctx.guiWidth() - textWidth - this.xPadding;
                int v6 = ctx.guiHeight();
                Objects.requireNonNull(font);
                yield new PointCollection(new Point(v5, v6 - 9 - this.yPadding), new Point(ctx.guiWidth() - this.xPadding, ctx.guiHeight() - this.yPadding));
            }
        };
    }

    public static enum Position {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }

    public record PointCollection(Point start, Point end) {
    }
}

