/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.gameclock;

import computer.livingroom.gameclock.Config;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import java.awt.Color;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class Utils {
    public static int getHexColor(Color color) {
        return color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static Screen makeConfigScreen(Screen parent) {
        Option bgColor = Option.createBuilder().name((Component)Component.literal((String)"Background Color")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Color of the background drawn on screen.")})).binding((Object)new Color(-1873784752), () -> ((Config)Config.HANDLER.instance()).backgroundColor, color -> {
            ((Config)Config.HANDLER.instance()).backgroundColor = color;
        }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true)).build();
        return YetAnotherConfigLib.createBuilder().title((Component)Component.literal((String)"GameClock")).category(ConfigCategory.createBuilder().name((Component)Component.literal((String)"GameClock")).group(OptionGroup.createBuilder().name((Component)Component.literal((String)"UI Options")).option(Option.createBuilder().name((Component)Component.literal((String)"UI Positioning")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Position where the time will be drawn.")})).binding((Object)Config.Position.BOTTOM_LEFT, () -> ((Config)Config.HANDLER.instance()).guiPosition, position -> {
            ((Config)Config.HANDLER.instance()).guiPosition = position;
        }).controller(positionOption -> EnumControllerBuilder.create((Option)positionOption).enumClass(Config.Position.class).formatValue(v -> Component.literal((String)(v.name().charAt(0) + v.name().substring(1).toLowerCase().replace('_', ' '))))).build()).option(Option.createBuilder().name((Component)Component.literal((String)"X Padding")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Add some pixel space in between the edge of the screen and the text.")})).binding((Object)5, () -> ((Config)Config.HANDLER.instance()).xPadding, integer -> {
            ((Config)Config.HANDLER.instance()).xPadding = integer;
        }).controller(integerOption -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)integerOption).range((Number)0, (Number)25)).step((Number)1)).formatValue(value -> Component.literal((String)(value + " px")))).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Y Padding")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Add some pixel space in between the edge of the screen and the text.")})).binding((Object)5, () -> ((Config)Config.HANDLER.instance()).yPadding, integer -> {
            ((Config)Config.HANDLER.instance()).yPadding = integer;
        }).controller(integerOption -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)integerOption).range((Number)0, (Number)25)).step((Number)1)).formatValue(value -> Component.literal((String)(value + " px")))).build()).build()).group(OptionGroup.createBuilder().name((Component)Component.literal((String)"Text Options")).option(Option.createBuilder().name((Component)Component.literal((String)"Text Color")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Color of the text drawn on screen.")})).binding((Object)new Color(0xFFFFFF), () -> ((Config)Config.HANDLER.instance()).textColor, color -> {
            ((Config)Config.HANDLER.instance()).textColor = color;
        }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true)).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Text Shadow")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Add a slight shadow to the text.")})).binding((Object)true, () -> ((Config)Config.HANDLER.instance()).shadowText, shadow -> {
            ((Config)Config.HANDLER.instance()).shadowText = shadow;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Leading 0")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Show a leading 0 on the clock.")})).binding((Object)false, () -> ((Config)Config.HANDLER.instance()).leadZero, bool -> {
            Config cfg = (Config)Config.HANDLER.instance();
            cfg.leadZero = bool;
            cfg.buildFormat();
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"Show Seconds")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Show the second-of-minute.")})).binding((Object)false, () -> ((Config)Config.HANDLER.instance()).showSeconds, bool -> {
            Config cfg = (Config)Config.HANDLER.instance();
            cfg.showSeconds = bool;
            cfg.buildFormat();
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.literal((String)"24-Hour Clock")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Toggle between using a 24-hour or a 12-hour clock.")})).binding((Object)false, () -> ((Config)Config.HANDLER.instance()).is24Hour, bool -> {
            Config cfg = (Config)Config.HANDLER.instance();
            cfg.is24Hour = bool;
            cfg.buildFormat();
        }).controller(BooleanControllerBuilder::create).build()).build()).group(OptionGroup.createBuilder().name((Component)Component.literal((String)"Background Options")).option(Option.createBuilder().name((Component)Component.literal((String)"Text Background")).description(OptionDescription.of((Component[])new Component[]{Component.literal((String)"Add a background to the clock.")})).binding((Object)false, () -> ((Config)Config.HANDLER.instance()).enableTextBackground, bool -> {
            ((Config)Config.HANDLER.instance()).enableTextBackground = bool;
        }).controller(BooleanControllerBuilder::create).addListener((option, event) -> bgColor.setAvailable(((Boolean)option.pendingValue()).booleanValue())).build()).option(bgColor).build()).build()).save(() -> Config.HANDLER.save()).build().generateScreen(parent);
    }
}

