/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.gameclock;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import java.awt.Point;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class Config {
    public static ConfigClassHandler<Config> HANDLER = ConfigClassHandler.createBuilder(Config.class).id(class_2960.method_43902((String)"gameclock", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(YACLPlatform.getConfigDir().resolve("gameclock.json5")).setJson5(true).build()).build();
    @SerialEntry
    public Position guiPosition = Position.BOTTOM_LEFT;
    @SerialEntry
    public Boolean shadowText = true;
    @SerialEntry(value="hexColor", comment="I messed up naming it hexcolor in v1 (this is text color)")
    public Color textColor = new Color(-1, true);
    @SerialEntry
    public int xPadding = 5;
    @SerialEntry
    public int yPadding = 5;
    @SerialEntry
    public boolean is24Hour = false;
    @SerialEntry
    public boolean enableTextBackground = false;
    @SerialEntry
    public Color backgroundColor = new Color(-1873784752, true);

    public String formatTime() {
        return !this.is24Hour ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("hh:mm a")) : LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public Point calculatePosition(class_332 ctx, String str, class_327 font) {
        int textWidth = font.method_1727(str);
        return switch (this.guiPosition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> new Point(0 + this.xPadding, 0 + this.yPadding);
            case 3 -> {
                int v1 = ctx.method_51443();
                Objects.requireNonNull(font);
                yield new Point(0 + this.xPadding, v1 - 9 - this.yPadding);
            }
            case 0 -> new Point(ctx.method_51421() - textWidth - this.xPadding, 0 + this.yPadding);
            case 1 -> {
                int v2 = ctx.method_51421() - textWidth - this.xPadding;
                int v3 = ctx.method_51443();
                Objects.requireNonNull(font);
                yield new Point(v2, v3 - 9 - this.yPadding);
            }
        };
    }

    public PointCollection calculatePositions(class_332 ctx, String str, class_327 font) {
        int textWidth = font.method_1727(str);
        return switch (this.guiPosition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> {
                Point v0 = new Point(0 + this.xPadding, 0 + this.yPadding);
                Objects.requireNonNull(font);
                yield new PointCollection(v0, new Point(0 + this.xPadding + textWidth, 0 + this.yPadding + 9));
            }
            case 3 -> {
                int v2 = ctx.method_51443();
                Objects.requireNonNull(font);
                yield new PointCollection(new Point(0 + this.xPadding, v2 - 9 - this.yPadding), new Point(0 + this.xPadding + textWidth, ctx.method_51443() - this.yPadding));
            }
            case 0 -> {
                Point v3 = new Point(ctx.method_51421() - textWidth - this.xPadding, 0 + this.yPadding);
                int v4 = ctx.method_51421() - this.xPadding;
                Objects.requireNonNull(font);
                yield new PointCollection(v3, new Point(v4, 0 + this.yPadding + 9));
            }
            case 1 -> {
                int v5 = ctx.method_51421() - textWidth - this.xPadding;
                int v6 = ctx.method_51443();
                Objects.requireNonNull(font);
                yield new PointCollection(new Point(v5, v6 - 9 - this.yPadding), new Point(ctx.method_51421() - this.xPadding, ctx.method_51443() - this.yPadding));
            }
        };
    }

    public static enum Position {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }

    public record PointCollection(Point start, Point end) {
    }
}

